package com.zoyi.channel.plugin.android.view.youtube.player.util;

import androidx.annotation.Nullable;

import com.zoyi.channel.plugin.android.view.youtube.player.PlayerConstants;
import com.zoyi.channel.plugin.android.view.youtube.player.YouTubePlayer;
import com.zoyi.channel.plugin.android.view.youtube.player.listener.AbstractYouTubePlayerListener;

public class PlaybackResumer extends AbstractYouTubePlayerListener {

  private boolean canLoad = false;
  private boolean isPlaying = false;

  @Nullable
  private PlayerConstants.PlayerError error;

  @Nullable
  private String currentVideoId;

  private float currentSecond = 0f;

  public void resume(YouTubePlayer youTubePlayer) {
    if (isPlaying && error == PlayerConstants.PlayerError.HTML_5_PLAYER) {
      YouTubePlayerUtils.loadOrCueVideo(youTubePlayer, canLoad, currentVideoId, currentSecond);
    } else if (!isPlaying && error == PlayerConstants.PlayerError.HTML_5_PLAYER) {
      youTubePlayer.cueVideo(currentVideoId, currentSecond);
    }

    error = null;
  }

  @Override
  public void onStateChange(YouTubePlayer youTubePlayer, PlayerConstants.PlayerState state) {
    switch (state) {
      case ENDED:
      case PAUSED:
        isPlaying = false;
        return;
      case PLAYING:
        isPlaying = true;
        return;
      default:
        break;
    }
  }

  @Override
  public void onError(YouTubePlayer youTubePlayer, PlayerConstants.PlayerError error) {
    if (error == PlayerConstants.PlayerError.HTML_5_PLAYER) {
      this.error = error;
    }
  }

  @Override
  public void onCurrentSecond(YouTubePlayer youTubePlayer, float second) {
    currentSecond = second;
  }

  @Override
  public void onVideoId(YouTubePlayer youTubePlayer, String videoId) {
    currentVideoId = videoId;
  }

  public void onLifecycleResume() {
    canLoad = true;
  }

  public void onLifecycleStop() {
    canLoad = false;
  }
}
