package com.zoyi.channel.plugin.android.view.video_player;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.media.instagram.InstagramMediaEntity;
import com.zoyi.channel.plugin.android.store.GlobalStore;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.com.google.android.exoplayer2.*;
import com.zoyi.com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.zoyi.com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.zoyi.com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.zoyi.com.google.android.exoplayer2.ui.PlayerView;
import com.zoyi.com.google.android.exoplayer2.upstream.DefaultHttpDataSourceFactory;
import com.zoyi.com.google.android.exoplayer2.util.Util;

import java.util.concurrent.TimeUnit;

public class InstagramVideoView extends AbsVideoPlayerView {

  public InstagramVideoView(@NonNull Context context) {
    super(context);

    init(context);
  }

  public InstagramVideoView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);

    init(context);
  }

  public InstagramVideoView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);

    init(context);
  }

  private Context context;

  private PlayerView player;

  @Nullable
  private SimpleExoPlayer exoPlayer;

  @Initializer
  private void init(Context context) {
    this.context = context;

    LayoutInflater.from(context).inflate(R.layout.ch_view_instagram_video_view, this);

    player = findViewById(R.id.ch_playerInstagram);
  }

  public InstagramVideoView setData(InstagramMediaEntity data, boolean isVolumeOn) {
    setId(data.getId());

    AdaptiveTrackSelection.Factory videoTrackSelectionFactory = new AdaptiveTrackSelection.Factory();
    DefaultTrackSelector trackSelector = new DefaultTrackSelector(videoTrackSelectionFactory);

    exoPlayer = ExoPlayerFactory.newSimpleInstance(context, new DefaultRenderersFactory(context), trackSelector);
    exoPlayer.addListener(new Player.EventListener() {
      @Override
      public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
        changeVideoState(playWhenReady);

        switch (playbackState) {
          case Player.STATE_ENDED:
            if (exoPlayer != null) {
              exoPlayer.seekTo(0);
              exoPlayer.setPlayWhenReady(true);
            }
            break;
        }
      }
    });

    player.setPlayer(exoPlayer);

    DefaultHttpDataSourceFactory dataSourceFactory = new DefaultHttpDataSourceFactory(
        Util.getUserAgent(context, "ChannelTalkSDK")
    );
    dataSourceFactory.getDefaultRequestProperties().set(Const.X_SESSION, GlobalStore.get().jwt.get());

    ExtractorMediaSource videoSource = new ExtractorMediaSource.Factory(dataSourceFactory)
        .createMediaSource(Uri.parse(data.getMediaUrl()));

    exoPlayer.prepare(videoSource);
    exoPlayer.setPlayWhenReady(false);
    exoPlayer.seekTo(getLatestSeconds() * TimeUnit.SECONDS.toMillis(1));

    applyVolumeButton(isVolumeOn);

    return this;
  }

  public void applyVolumeButton(boolean isVolumeOn) {
    if (exoPlayer != null) {
      exoPlayer.setVolume(isVolumeOn ? 1f : 0f);
    }

    changeVideoVolumeState(isVolumeOn);
  }

  public void onActive() {
    if (exoPlayer != null) {
      exoPlayer.setPlayWhenReady(true);
    }
  }

  public void onDeactivate() {
    if (exoPlayer != null) {
      exoPlayer.setPlayWhenReady(false);
    }
  }

  @Override
  void onVideoPaused() {
    if (exoPlayer != null) {
      exoPlayer.setPlayWhenReady(false);
    }
  }

  // clear


  @Override
  public void clear() {
    super.clear();

    if (exoPlayer != null) {
      exoPlayer.release();
      exoPlayer = null;
    }
  }
}
