package com.zoyi.channel.plugin.android.view.toggle;

import android.content.Context;
import android.content.res.TypedArray;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.SwitchCompat;
import android.util.AttributeSet;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.open.option.Language;
import com.zoyi.channel.plugin.android.selector.SettingsSelector;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;

public class CHToggleView extends SwitchCompat {

  private Context context;

  @Nullable
  private String textKey;

  @Nullable
  private Binder binder;

  public CHToggleView(Context context) {
    super(context);
    init(context, null);
  }

  public CHToggleView(Context context, AttributeSet attrs) {
    super(context, attrs);
    init(context, attrs);
  }

  public CHToggleView(Context context, AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context, attrs);
  }

  @Initializer
  private void init(Context context, @Nullable AttributeSet attrs) {
    this.context = context;

    if (attrs != null) {
      TypedArray typedArray = getContext().obtainStyledAttributes(attrs, R.styleable.CHToggleView);

      try {
        textKey = typedArray.getString(R.styleable.CHToggleView_ch_toggle_textKey);
      } finally {
        typedArray.recycle();
      }
    }
  }

  @Override
  protected void onAttachedToWindow() {
    super.onAttachedToWindow();

    binder = SettingsSelector.bindLanguage(language -> setTextKey(language, textKey));
  }

  @Override
  protected void onDetachedFromWindow() {
    super.onDetachedFromWindow();

    if (binder != null) {
      binder.unbind();
      binder = null;
    }
  }

  private void setTextKey(Language language, @Nullable String textKey) {
    if (textKey != null) {
      setText(ResUtils.getString(context, language, textKey));
    } else {
      setText(null);
    }
  }
}
