package com.zoyi.channel.plugin.android.view.media_thumbnail;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.util.AttributeSet;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.WebPage;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UriUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.video_player.YouTubeVideoPlayerView;

public class WebPageMediaThumbnailView extends MediaThumbnailView {

  public WebPageMediaThumbnailView(@NonNull Context context) {
    super(context);

    init(context);
  }

  public WebPageMediaThumbnailView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);

    init(context);
  }

  public WebPageMediaThumbnailView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);

    init(context);
  }

  @Initializer
  private void init(Context context) {
    this.context = context;

    setBorderRadius(Utils.dpToPx(context, 8));
    setBorderWidth(Utils.dpToPx(context, 1));
    setBorderColor(ResUtils.getColor(context, R.color.ch_grey300));
  }

  private Context context;

  @Nullable
  private String messageId;
  @Nullable
  private WebPage webPage;

  public void setWebPage(@Nullable String messageId, WebPage webPage) {
    this.messageId = messageId;
    this.webPage = webPage;

    setImage(webPage.getPreviewUrl());

    if (Const.PUBLISHER_YOUTUBE.equals(webPage.getPublisher())) {
      activatePlayButton();
    }
  }

  @Override
  public void onPlayClick() {
    if (webPage != null && webPage.getId() != null && webPage.getUrl() != null) {
      super.onPlayClick();

      String videoId = UriUtils.getYouTubeVideoId(webPage.getUrl());

      if (Const.PUBLISHER_YOUTUBE.equals(webPage.getPublisher()) && videoId != null) {
        appendVideoView(new YouTubeVideoPlayerView(context)).setVideoId(messageId, webPage.getId(), videoId);
      }
    }
  }
}
