package com.zoyi.channel.plugin.android.view.media_thumbnail;

import android.content.Context;
import android.graphics.Point;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.util.AttributeSet;
import android.widget.ImageView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.contentview.OnAttachmentContentActionListener;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.draw.Display;

public class OriginAttachmentMediaThumbnailView extends AttachmentMediaThumbnailView {

  public OriginAttachmentMediaThumbnailView(@NonNull Context context) {
    super(context);

    init(context);
  }

  public OriginAttachmentMediaThumbnailView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);

    init(context);
  }

  public OriginAttachmentMediaThumbnailView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);

    init(context);
  }

  private Context context;

  private int resolvedWidth = 0;
  private int resolvedHeight = 0;

  private int minWidth;
  private int minHeight;
  private int maxHeight;

  private void init(Context context) {
    this.context = context;

    minWidth = ResUtils.getDimen(context, R.dimen.ch_chat_message_attachments_min_size);
    minHeight = ResUtils.getDimen(context, R.dimen.ch_chat_message_attachments_min_size);
    maxHeight = Display.getHeight(context) / 2;
  }

  @Override
  public void setAttachment(
      @Nullable String messageId,
      File attachment,
      @Nullable OnAttachmentContentActionListener listener
  ) {
    super.setAttachment(messageId, attachment, listener);

    int screenWidth = Display.getWidth(context);
    int imageWidth = Math.max(attachment.getWidth(), 1);
    int imageHeight = Math.max(attachment.getHeight(), 1);

    resolvedWidth = Math.min(imageWidth, screenWidth);
    resolvedHeight = Math.min(imageHeight, Math.max(1, imageHeight * screenWidth / imageWidth));

    setImage(attachment.getThumbnailURL(new Point(resolvedWidth, resolvedHeight)), ImageView.ScaleType.FIT_CENTER);

    requestLayout();
  }

  @Override
  protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
    int measuredWidth = MeasureSpec.getSize(widthMeasureSpec);
    int viewWidth = resolvedWidth;
    int viewHeight = resolvedHeight;

    if (resolvedWidth > measuredWidth && resolvedHeight > maxHeight) {
      float resolvedRatio = Math.max((float) resolvedWidth / measuredWidth, (float) resolvedHeight / maxHeight);
      viewWidth = (int) (resolvedWidth / resolvedRatio);
      viewHeight = (int) (resolvedHeight / resolvedRatio);
    } else if (resolvedWidth > measuredWidth) {
      viewWidth = measuredWidth;
      viewHeight = resolvedHeight * measuredWidth / resolvedWidth;
    } else if (resolvedHeight > maxHeight) {
      viewWidth = measuredWidth * maxHeight / resolvedHeight;
      viewHeight = maxHeight;
    }

    super.onMeasure(
        MeasureSpec.makeMeasureSpec(Math.max(viewWidth, minWidth), MeasureSpec.EXACTLY),
        MeasureSpec.makeMeasureSpec(Math.max(viewHeight, minHeight), MeasureSpec.EXACTLY)
    );
  }
}
