package com.zoyi.channel.plugin.android.view.layout.message;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.view.textview.EllipsizeTextView;
import com.zoyi.channel.plugin.android.view.textview.LinkMovementMethodOverride;

public class TextBlockView extends FrameLayout implements BlockView {

  private AppCompatTextView textPrefix;
  private EllipsizeTextView textMessage;

  private int textSize;
  private float textLineSpacingExtra;
  private int textColor;
  private int textLinkColor;
  private int maxLines;

  @Nullable
  private String prefix;

  private boolean isPlainText = false;

  public TextBlockView(@NonNull Context context) {
    super(context);

    View root = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_block_text, this);

    textPrefix = root.findViewById(R.id.ch_textBlockPrefix);
    textMessage = root.findViewById(R.id.ch_textBlock);
    textMessage.setOnTouchListener(new LinkMovementMethodOverride());
  }

  public TextBlockView setPrefix(@Nullable String prefix) {
    this.prefix = prefix;

    return this;
  }

  public TextBlockView build(CharSequence charSequence) {
    if (prefix != null) {
      textPrefix.setText(prefix);
    }

    if (charSequence == null) {
      textMessage.setText("");
    } else {
      textMessage.setText(isPlainText ? charSequence.toString() : charSequence);
      textMessage.append(" ");
    }

    if (textSize != 0) {
      textPrefix.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSize);
      textMessage.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSize);
    }

    if (maxLines != 0) {
      textMessage.setMaxLines(maxLines);
    }

    textPrefix.setLineSpacing(textLineSpacingExtra, 1f);
    textMessage.setLineSpacing(textLineSpacingExtra, 1f);

    if (textColor != 0) {
      this.textPrefix.setTextColor(textColor);
      this.textMessage.setTextColor(textColor);
    }

    if (textLinkColor != 0) {
      this.textMessage.setLinkTextColor(textLinkColor);
    }
    return this;
  }

  public TextBlockView setTextSize(int textSize) {
    this.textSize = textSize;

    return this;
  }

  public TextBlockView setLineSpacingExtra(float lineSpacingExtra) {
    textLineSpacingExtra = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_PX, lineSpacingExtra, getResources().getDisplayMetrics());

    return this;
  }

  public TextBlockView setTextColor(int textColor) {
    this.textColor = textColor;

    return this;
  }

  public TextBlockView setTextLinkColor(int textLinkColor) {
    this.textLinkColor = textLinkColor;

    return this;
  }

  public TextBlockView setPlainText(boolean isPlainText) {
    this.isPlainText = isPlainText;
    return this;
  }

  public TextBlockView setMaxLines(int maxLines) {
    this.maxLines = maxLines;

    return this;
  }

  @Override
  public void clear() {
    textSize = 0;
    textLineSpacingExtra = 0;
    textColor = 0;
    maxLines = 0;
    prefix = null;
    isPlainText = false;
    textPrefix.setText("");
    textMessage.setText("");
  }
}
