package com.zoyi.channel.plugin.android.view.integrations.instagram;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.ViewPager;

import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.*;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.media.instagram.*;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.dock.DockLayout;
import com.zoyi.channel.plugin.android.view.layout.PhotoViewPager;
import com.zoyi.com.annimon.stream.Stream;

import java.text.NumberFormat;
import java.util.*;

public class InstagramView extends FrameLayout implements OnInstagramThumbnailClickListener {

  public InstagramView(@NonNull Context context) {
    super(context);

    init(context);
  }

  public InstagramView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);

    init(context);
  }

  public InstagramView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);

    init(context);
  }

  private DockLayout dockLayout;

  private PhotoViewPager viewPager;
  private InstagramMediaAdapter adapter;

  private TextView textUsername;

  private View viewPage;
  private TextView textPage;

  private View buttonVolume;
  private ImageView iconVolume;

  private TextView textLike;
  private TextView textComment;

  private boolean isVolumeOn = false;

  private List<String> dataTypes = Collections.emptyList();
  private int totalPages = 0;

  @Initializer
  private void init(Context context) {
    LayoutInflater.from(context).inflate(R.layout.ch_view_integration_instagram, this);

    dockLayout = findViewById(R.id.ch_dockInstagram);

    adapter = new InstagramMediaAdapter(context);
    viewPager = findViewById(R.id.ch_viewPagerInstagram);
    viewPager.setAdapter(adapter);
    viewPager.addOnPageChangeListener(new ViewPager.SimpleOnPageChangeListener() {
      @Override
      public void onPageSelected(int position) {
        onPageChanged(position);
      }
    });

    textUsername = findViewById(R.id.ch_textInstagramUsername);

    viewPage = findViewById(R.id.ch_viewInstagramPage);
    textPage = findViewById(R.id.ch_textInstagramPage);

    iconVolume = findViewById(R.id.ch_iconInstagramVolume);

    buttonVolume = findViewById(R.id.ch_viewInstagramVolume);
    buttonVolume.setOnClickListener(v -> {
      this.isVolumeOn = !this.isVolumeOn;

      if (iconVolume != null) {
        iconVolume.setImageResource(isVolumeOn ? R.drawable.ch_volume_up_filled_16 : R.drawable.ch_volume_off_filled_16);
      }

      if (adapter != null) {
        adapter.changeVideoVolumeState(this.isVolumeOn);
      }
    });

    textLike = findViewById(R.id.ch_textInstagramLike);
    textComment = findViewById(R.id.ch_textInstagramComment);
  }

  public void setInstagram(Instagram instagram) {
    if (!instagram.getData().isEmpty()) {
      setData(instagram.getData().get(0));
    }

    // set preview items
    dockLayout.removeAllViews();

    for (InstagramData data : instagram.getData()) {
      dockLayout.addView(new InstagramPreviewItemView(getContext(), data, this));
    }
  }

  private void setData(InstagramData data) {
    this.dataTypes = Stream.ofNullable(data.getData()).map(InstagramMediaEntity::getMediaType).toList();
    this.totalPages = data.getData().size();

    adapter.setItems(data);

    textUsername.setText(data.getUsername());

    Views.setVisibility(viewPage, data.getData().size() > 1);

    textLike.setText(NumberFormat.getInstance(Locale.US).format(data.getLikeCount()));
    textComment.setText(NumberFormat.getInstance(Locale.US).format(data.getCommentsCount()));

    onPageChanged(0);
  }

  @Override
  public void onDataClick(InstagramData data) {
    setData(data);
  }

  private void onPageChanged(int currentPage) {
    textPage.setText(String.format(Locale.US, "%d/%d", currentPage + 1, this.totalPages));

    Views.setVisibility(
        buttonVolume,
        currentPage < this.dataTypes.size() && Const.APP_MEDIA_INSTAGRA_MEDIA_TYPE_VIDEO.equals(this.dataTypes.get(currentPage))
    );

    if (adapter != null) {
      adapter.onPageChanged(currentPage);
    }
  }
}
