package com.zoyi.channel.plugin.android.view.integrations.instagram;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.view.LayoutInflater;
import android.widget.FrameLayout;
import android.widget.ImageView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.media.instagram.InstagramData;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.com.bumptech.glide.Glide;

public class InstagramPreviewItemView extends FrameLayout {

  public InstagramPreviewItemView(@NonNull Context context, InstagramData data, OnInstagramThumbnailClickListener listener) {
    super(context);

    init(context, data, listener);
  }

  @Initializer
  private void init(Context context, InstagramData data, OnInstagramThumbnailClickListener listener) {
    LayoutInflater.from(context).inflate(R.layout.ch_view_integration_instagram_preview_item, this);

    ImageView imageView = findViewById(R.id.ch_imageInstagramPreviewItem);

    switch (data.getMediaType()) {
      case Const.APP_MEDIA_INSTAGRA_MEDIA_TYPE_IMAGE:
      case Const.APP_MEDIA_INSTAGRA_MEDIA_TYPE_CAROUSEL_ALBUM:
        setImage(imageView, data.getMediaUrl());
        break;

      case Const.APP_MEDIA_INSTAGRA_MEDIA_TYPE_VIDEO:
        setImage(imageView, data.getThumbnailUrl());
        break;
    }

    setOnClickListener(v -> listener.onDataClick(data));
  }

  private void setImage(ImageView imageView, @Nullable String imageUrl) {
    if (imageUrl != null) {
      Glide.with(getContext())
          .load(imageUrl)
          .centerCrop()
          .into(imageView);
    }
  }
}
