package com.zoyi.channel.plugin.android.view.integrations.instagram;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.util.AttributeSet;
import android.widget.ImageView;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.media.instagram.InstagramMediaEntity;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.media_thumbnail.MediaThumbnailView;
import com.zoyi.channel.plugin.android.view.video_player.InstagramVideoView;

public class InstagramMediaView extends MediaThumbnailView {

  public InstagramMediaView(@NonNull Context context) {
    super(context);

    init(context);
  }

  public InstagramMediaView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);

    init(context);
  }

  public InstagramMediaView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);

    init(context);
  }

  private Context context;

  @Nullable
  private InstagramVideoView videoView;

  @Initializer
  private void init(Context context) {
    this.context = context;
  }

  public void setData(InstagramMediaEntity data, boolean isVolumeOn) {
    if (Const.APP_MEDIA_INSTAGRA_MEDIA_TYPE_VIDEO.equals(data.getMediaType())) {
      if (data.getThumbnailUrl() != null) {
        super.onPlayClick();

        this.videoView = appendVideoView(new InstagramVideoView(context).setData(data, isVolumeOn));
      }
    } else if (data.getThumbnailUrl() != null) {
      setImage(data.getThumbnailUrl(), ImageView.ScaleType.FIT_CENTER);
    } else if (data.getMediaUrl() != null) {
      setImage(data.getMediaUrl(), ImageView.ScaleType.FIT_CENTER);
    }
  }

  public void onActive() {
    if (this.videoView != null) {
      this.videoView.onActive();
    }
  }

  public void onDeactive() {
    if (this.videoView != null) {
      this.videoView.onDeactivate();
    }
  }

  public void changeVideoVolumeState(boolean isVolumeOn) {
    if (this.videoView != null) {
      this.videoView.applyVolumeButton(isVolumeOn);
    }
  }
}
