package com.zoyi.channel.plugin.android.view.dialog;

import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.DatePicker;
import android.widget.TimePicker;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.enumerate.ButtonType;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.rx.functions.Action1;

import java.util.Calendar;
import java.util.TimeZone;

public class DatetimeDialog extends BaseDialog<DatetimeDialog> {

  private DatePicker datePicker;
  private TimePicker timePicker;

  @Nullable
  private Action1<Long> listener;

  public DatetimeDialog(@NonNull Context context) {
    super(context);

    View contentView = (LayoutInflater.from(context).inflate(R.layout.ch_view_datetime_dialog, null));

    datePicker = contentView.findViewById(R.id.ch_datepickerDateTimeDialog);
    timePicker = contentView.findViewById(R.id.ch_timepickerDateTimeDialog);

    addButton(ButtonType.CANCEL);
    addButton(ButtonType.OK, ResUtils.getColor(R.color.ch_blue400), v -> onClickOk());

    setContent(contentView);
  }

  public void show(@Nullable Long timestamp, Action1<Long> listener) {
    this.listener = listener;

    if (timestamp != null) {
      setTimestamp(timestamp);
    } else {
      setTimestamp(TimeUtils.getCurrentTime());
    }

    super.show();
  }

  private void setTimestamp(long timestamp) {
    Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
    calendar.setTimeInMillis(timestamp);

    if (datePicker != null && timePicker != null) {
      datePicker.updateDate(calendar.get(Calendar.YEAR), calendar.get(Calendar.MONTH), calendar.get(Calendar.DAY_OF_MONTH));

      if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
        timePicker.setHour(calendar.get(Calendar.HOUR_OF_DAY));
        timePicker.setMinute(calendar.get(Calendar.MINUTE));
      } else {
        timePicker.setCurrentHour(calendar.get(Calendar.HOUR_OF_DAY));
        timePicker.setCurrentMinute(calendar.get(Calendar.MINUTE));
      }
    }
  }

  private void onClickOk() {
    Calendar calendar = Calendar.getInstance(TimeZone.getDefault());

    if (datePicker != null && timePicker != null) {
      if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
        calendar.set(
            datePicker.getYear(),
            datePicker.getMonth(),
            datePicker.getDayOfMonth(),
            timePicker.getHour(),
            timePicker.getMinute(),
            0
        );
      } else {
        calendar.set(
            datePicker.getYear(),
            datePicker.getMonth(),
            datePicker.getDayOfMonth(),
            timePicker.getCurrentHour(),
            timePicker.getCurrentMinute(),
            0
        );
      }

      if (listener != null) {
        listener.call(calendar.getTimeInMillis());
      }
    }
  }
}
