package com.zoyi.channel.plugin.android.view.dialog;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import com.zoyi.channel.plugin.android.model.rest.Country;
import com.zoyi.channel.plugin.android.util.CompareUtils;

import java.util.ArrayList;
import java.util.List;

public class CountryCodeDialog extends AlertDialog.Builder {

  public interface OnCountryCodeSelectListener {

    void onCountryCodeSelected(int position, String countryCode);
  }

  public CountryCodeDialog(@NonNull Context context, List<Country> countries, @Nullable OnCountryCodeSelectListener listener) {
    super(context);

    setSingleChoiceItems(getItems(countries), -1, (dialog, which) -> {
      if (listener != null) {
        listener.onCountryCodeSelected(which, countries.get(which).getCallingCode());
      }
      dialog.dismiss();
    });
  }

  private String[] getItems(List<Country> countries) {
    ArrayList<String> items = new ArrayList<>();

    for (Country country : countries) {
      items.add(String.format("%s (+%s)", country.getName(), country.getCallingCode()));
    }
    return items.toArray(new String[items.size()]);
  }

  private int getItemPosition(String countryName, List<Country> countries) {
    int position = 0;

    for (int i = 0; i < countries.size(); i++) {
      if (CompareUtils.isSame(countries.get(i).getName(), countryName)) {
        position = i;
        break;
      }
    }
    return position;
  }
}
