package com.zoyi.channel.plugin.android.view.button;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.enumerate.ButtonTheme;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.view.layout.ChBorderLayout;

public abstract class LinkButton extends FrameLayout {

  public String text = "";
  public int textColor = R.color.ch_grey900;
  public int backColor = R.color.ch_black_5;

  private ChBorderLayout layoutLinkButton;
  private TextView textLinkButton;

  public LinkButton(@NonNull Context context) {
    super(context);
    init(context);
  }

  public LinkButton(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public LinkButton(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  @Initializer
  private void init(Context context) {
    View view = LayoutInflater.from(context).inflate(R.layout.ch_view_link_button, this, true);

    layoutLinkButton = view.findViewById(R.id.ch_layoutLinkButton);
    textLinkButton = view.findViewById(R.id.ch_textLinkButton);
  }

  public void initMessageLinkButton() {
    setText("");
    setTextColor(ResUtils.getColor(R.color.ch_grey900));
  }

  public void initPopupLinkButton() {
    setBackColor(ResUtils.getColor(R.color.ch_black_5));
    setText("");
    setTextColor(ResUtils.getColor(R.color.ch_grey900));
    setTypeface(Typeface.NORMAL);
  }

  public void setText(String text) {
    this.text = text;
    if (textLinkButton != null) {
      textLinkButton.setText(text);
    }
  }

  public void setMessageTheme(ButtonTheme buttonTheme) {
    if (buttonTheme != ButtonTheme.UNKNOWN) {
      setTextColor(ResUtils.getColor(buttonTheme.getColor()));
    }
  }

  public void setPopupTheme(ButtonTheme buttonTheme) {
    if (buttonTheme != ButtonTheme.UNKNOWN) {
      setBackColor(ResUtils.getColor(buttonTheme.getColor()));
      setTextColor(Color.WHITE);
      setTypeface(Typeface.BOLD);
    }
  }

  private void setBorderWidth(float width) {
    if (layoutLinkButton != null) {
      layoutLinkButton.setBorderWidth(width);
    }
  }

  private void setBorderColor(int color) {
    if (layoutLinkButton != null) {
      layoutLinkButton.setBorderColor(color);
    }
  }

  private void setTextColor(int textColor) {
    this.textColor = textColor;
    if (textLinkButton != null) {
      textLinkButton.setTextColor(textColor);
    }
  }

  private void setBackColor(int backColor) {
    this.backColor = backColor;
    if (layoutLinkButton != null) {
      layoutLinkButton.setBackColor(backColor);
    }
  }

  private void setTypeface(int typeface) {
    if (textLinkButton != null) {
      textLinkButton.setTypeface(textLinkButton.getTypeface(), typeface);
    }
  }
}
