package com.zoyi.channel.plugin.android.util.draw;

import android.app.Activity;
import android.app.KeyguardManager;
import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.WindowManager;

import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.util.ContextUtils;
import com.zoyi.com.annimon.stream.Optional;

public class Display {

  /**
   * Physical size (INCH")
   * ref : http://screensiz.es
   */
  private static final double MAXIMUM_MOBILE_DISPLAY_SIZE = 6.5;

  public static int getWidth(Context context) {
    Activity activity = ContextUtils.getActivity(context);

    if (activity != null) {
      return getWidth(activity);
    }
    WindowManager wm = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
    android.view.Display display = wm.getDefaultDisplay();
    Point outSize = new Point();
    display.getSize(outSize);
    return outSize.x;
  }

  public static int getWidth(Activity activity) {
    DisplayMetrics metrics = new DisplayMetrics();
    activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);

    return metrics.widthPixels;
  }

  public static int getHeight(Context context) {
    Activity activity = ContextUtils.getActivity(context);

    if (activity != null) {
      return getHeight(activity);
    }
    WindowManager wm = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
    android.view.Display display = wm.getDefaultDisplay();
    Point outSize = new Point();
    display.getSize(outSize);
    return outSize.y;
  }

  public static int getHeight(Activity activity) {
    DisplayMetrics metrics = new DisplayMetrics();
    activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);

    return metrics.heightPixels;
  }


  // Determine device type by checking display physical size
  public static boolean isMobile() {
    Context context = ChannelIO.getAppContext();
    if (context == null) {
      return true;
    }

    DisplayMetrics metrics = new DisplayMetrics();
    WindowManager wm = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
    wm.getDefaultDisplay().getMetrics(metrics);

    float yInches = metrics.heightPixels / metrics.ydpi;
    float xInches = metrics.widthPixels / metrics.xdpi;
    double diagonalInches = Math.sqrt((xInches * xInches) + (yInches * yInches));

    return diagonalInches < MAXIMUM_MOBILE_DISPLAY_SIZE;
  }

  public static boolean isLocked() {
    return Optional.ofNullable(ChannelIO.getAppContext())
        .map(context -> (KeyguardManager) context.getSystemService(Context.KEYGUARD_SERVICE))
        .map(keyguardManager -> {
          if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP_MR1) {
            return keyguardManager.isKeyguardLocked();
          }
          return keyguardManager.inKeyguardRestrictedInputMode();
        })
        .orElse(true);
  }
}
