package com.zoyi.channel.plugin.android.util;

import androidx.annotation.Nullable;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Action0;
import com.zoyi.rx.schedulers.Schedulers;

import java.util.concurrent.TimeUnit;

public class RxUtils {

  public static Subscription debounce(@Nullable Subscription oldSubscription, long delayMilliseconds, Action0 action0) {
    if (oldSubscription != null && !oldSubscription.isUnsubscribed()) {
      oldSubscription.unsubscribe();
    }

    return Observable.timer(delayMilliseconds, TimeUnit.MILLISECONDS)
        .onBackpressureBuffer()
        .subscribeOn(Schedulers.computation())
        .observeOn(AndroidSchedulers.mainThread())
        .subscribe(aLong -> action0.call());
  }
}
