package com.zoyi.channel.plugin.android.util;

import androidx.core.util.Pair;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;

/**
 * Created by jerry on 2018. 8. 7..
 */

public class RegexUtils {
  public static List<Pair<Integer, Integer>> getRange(Matcher matcher) {
    List<Pair<Integer, Integer>> rangeList = new ArrayList<>();

    while (matcher.find()) {
      if (rangeList.isEmpty() || rangeList.get(rangeList.size() - 1).second <= matcher.start()) {
        rangeList.add(new Pair<>(matcher.start(), matcher.end()));
      }
    }

    return rangeList;
  }

  public static List<Pair<Integer, Integer>> getReversedRange(Matcher matcher) {
    List<Pair<Integer, Integer>> reversedRangeList = getRange(matcher);
    Collections.reverse(reversedRangeList);
   return reversedRangeList;
  }
}
