package com.zoyi.channel.plugin.android.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.provider.MediaStore;
import androidx.annotation.Nullable;
import android.text.TextUtils;

import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelPluginListener;
import com.zoyi.channel.plugin.android.activity.video.VideoViewerActivity;
import com.zoyi.channel.plugin.android.enumerate.LinkType;
import com.zoyi.channel.plugin.android.global.ChannelFileProvider;
import com.zoyi.channel.plugin.android.global.Const;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Executor {

  public static boolean takePhoto(Activity activity) {
    Intent takePictureIntent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);

    File photoFile = getPhotoFile(activity);
    if (photoFile == null) {
      return false;
    }

    tempPhotoFile = photoFile;

    takePictureIntent.putExtra(
        MediaStore.EXTRA_OUTPUT,
        ChannelFileProvider.getUriForFile(activity, photoFile));

    if (takePictureIntent.resolveActivity(activity.getPackageManager()) != null) {
      activity.startActivityForResult(takePictureIntent, Const.REQUEST_TAKE_PHOTO);
      return true;
    }
    return false;
  }

  public static void startFileMediaScan(Activity activity, String filePath) {
    startFileMediaScan(activity, new File(filePath));
  }

  public static void startFileMediaScan(Activity activity, File file) {
    Intent mediaScanIntent = new Intent(Intent.ACTION_MEDIA_SCANNER_SCAN_FILE);

    mediaScanIntent.setData(Uri.fromFile(file));
    activity.sendBroadcast(mediaScanIntent);
  }

  public static void executeLinkAction(@Nullable Context context, @Nullable String link, LinkType linkType) {
    if (context != null && link != null) {
      boolean handleLink = false;

      com.zoyi.channel.plugin.android.open.listener.ChannelPluginListener listener = ChannelIO.getListener();

      if (listener != null) {
        handleLink = listener.onUrlClicked(link);
      }

      ChannelPluginListener legacyListener = ChannelIO.getLegacyListener();

      if (!handleLink && legacyListener != null) {
        handleLink = legacyListener.onClickChatLink(link);
      }

      if (!handleLink) {
        switch (linkType) {
          case URL:
            IntentUtils.setUrl(context, link).startActivity();
            break;

          case EMAIL:
            IntentUtils.setEmail(context, link).startActivity();
            break;
        }
      }
    }
  }

  private static File tempPhotoFile = null;

  public static File getTempPhotoFile() {
    return tempPhotoFile;
  }

  @SuppressLint("SimpleDateFormat")
  private static File getPhotoFile(Context context) {
    try {
      String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());

      return File.createTempFile(timeStamp, ".jpg", context.getCacheDir());
    } catch (IOException e) {
      e.printStackTrace();
    }
    return null;
  }

  public static boolean canCall(Context context) {
    return context != null && context.getPackageManager().hasSystemFeature(PackageManager.FEATURE_TELEPHONY);
  }

  public static void openEmail(Context context, @Nullable String email) {
    if (TextUtils.isEmpty(email)) {
      return;
    }

    IntentUtils.setEmail(context, email).startActivity();
  }

  public static void openCall(Context context, @Nullable String phoneNumber) {
    if (TextUtils.isEmpty(phoneNumber) || !canCall(context)) {
      return;
    }

    IntentUtils.setPhone(context, ParseUtils.parsePhoneNumber(context, phoneNumber)).startActivity();
  }

  public static void startFullScreenVideo(Context context, com.zoyi.channel.plugin.android.model.rest.File attachment, long startAt) {
    IntentUtils.setNextActivity(context, VideoViewerActivity.class)
        .putExtra(Const.EXTRA_FILE_NAME, attachment.getName())
        .putExtra(Const.EXTRA_URL, attachment.getUrl())
        .putExtra(Const.EXTRA_START_AT, startAt)
        .startActivity();
  }
}
