package com.zoyi.channel.plugin.android.store.state;

import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.com.annimon.stream.Stream;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ExpirableEntityMapState<E extends Entity> extends BaseState<Map<String, E>> {

  private final long TTL;

  private final Object locker = new Object();

  private Map<String, E> map = new HashMap<>();
  private Map<String, Subscription> subscriptions = new HashMap<>();

  public ExpirableEntityMapState(long TTL) {
    this.TTL = TTL;
  }

  private void removeSubscription(String id) {
    Subscription subscription = this.subscriptions.remove(id);

    if (subscription != null && !subscription.isUnsubscribed()) {
      subscription.unsubscribe();
    }
  }

  private void clear() {
    this.map.clear();

    Stream.ofNullable(this.subscriptions.values())
        .forEach(subscription -> {
          if (subscription != null && !subscription.isUnsubscribed()) {
            subscription.unsubscribe();
          }
        });

    this.subscriptions.clear();
  }

  public void upsert(E data) {
    if (data != null) {
      synchronized (locker) {
        E oldbie = this.map.get(data.getId());

        if (oldbie != null) {
          removeSubscription(data.getId());
        } else {
          this.map.put(data.getId(), data);
          post();
        }

        subscriptions.put(
            data.getId(),
            Observable.timer(TTL, TimeUnit.SECONDS, Schedulers.computation())
                .onBackpressureBuffer()
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(ignored -> remove(data))
        );
      }
    }
  }

  public void remove(E data) {
    if (data != null) {
      synchronized (locker) {
        this.map.remove(data.getId());

        removeSubscription(data.getId());
        post();
      }
    }
  }

  @Nullable
  @Override
  public Map<String, E> get() {
    synchronized (locker) {
      return this.map;
    }
  }

  @Override
  public void reset() {
    synchronized (locker) {
      clear();
    }
  }
}
