package com.zoyi.channel.plugin.android.selector;

import android.content.Context;
import androidx.annotation.NonNull;

import com.zoyi.channel.plugin.android.activity.lounge.view.app_messenger.model.LinkContact;
import com.zoyi.channel.plugin.android.activity.lounge.view.app_messenger.model.PhoneContact;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.model.entity.Contact;
import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.store.*;
import com.zoyi.channel.plugin.android.store.binder.Binder3;
import com.zoyi.channel.plugin.android.store.state.CollectionState;
import com.zoyi.channel.plugin.android.store.state.State;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.rx.functions.Action1;

import java.util.ArrayList;
import java.util.List;

public class AppMessengerSelector {

  public static Binder bindIntegrations(@NonNull Context context, Action1<List<Contact>> action1) {
    State<Channel> channelState = ChannelStore.get().channelState;
    State<Plugin> pluginState = PluginStore.get().pluginState;
    CollectionState<AppMessenger> appMessengerState = AppMessengerStore.get().appMessengers;

    return new Binder3<>(channelState, pluginState, appMessengerState).bind((channel, plugin, appMessengers) -> {
      List<Contact> contacts = new ArrayList<>(appMessengers);

      // default link
      if (channel != null &&
          plugin != null &&
          channel.getDomain() != null &&
          channel.getDefaultPluginId() != null &&
          channel.getDefaultPluginId().equals(plugin.getId())
      ) {
        contacts.add(new LinkContact(String.format("https://%s.channel.io", channel.getDomain())));
      }

      // phone
      if (channel != null && channel.getPhoneNumber() != null && Executor.canCall(context)) {
        contacts.add(new PhoneContact(channel.getPhoneNumber()));
      }

      action1.call(contacts);
    });
  }
}
