package com.zoyi.channel.plugin.android.network;

import android.content.pm.PackageManager;
import androidx.annotation.Nullable;

import com.zoyi.channel.plugin.android.BuildConfig;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.okhttp3.*;

import java.io.IOException;

public class UserAgentInterceptor implements Interceptor {

  @Nullable
  private String hostAppHeader;

  private String getSdkHeader() {
    return String.format("android/%s", BuildConfig.CHANNEL_IO_VERSION);
  }

  private String getHostAppHeader() {
    if (hostAppHeader == null) {
      hostAppHeader = Optional.ofNullable(ChannelIO.getAppContext())
          .map(context -> {
                try {
                  return String.format(
                      "%s/%s",
                      context.getPackageName(),
                      context.getPackageManager().getPackageInfo(context.getPackageName(), 0).versionName);
                } catch (PackageManager.NameNotFoundException e) {
                  return null;
                }
              }
          )
          .orElse(null);
    }

    if (hostAppHeader != null) {
      return hostAppHeader;
    }
    return "";
  }

  private String getUserAgent() {
    return System.getProperty(Const.DEFAULT_ANDROID_USER_AGENT);
  }

  @Override
  public Response intercept(Chain chain) throws IOException {

    Request request = chain.request()
        .newBuilder()
        .header(Const.X_CHANNEL_SDK, getSdkHeader())
        .header(Const.X_HOST_APP, getHostAppHeader())
        .header(Const.HEADER_USER_AGENT, getUserAgent())
        .build();

    return chain.proceed(request);
  }
}
