package com.zoyi.channel.plugin.android.network;

import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.okhttp3.Interceptor;
import com.zoyi.okhttp3.Request;
import com.zoyi.okhttp3.Response;

import java.io.IOException;
import java.util.Date;

/**
 * Created by mika on 2018. 10. 31..
 */

public class ServerTimeInterceptor implements Interceptor {

  @Override
  public Response intercept(Chain chain) throws IOException {
    Request request = chain.request();
    Response response = chain.proceed(request);

    if (response != null && response.headers() != null) {
      Date date = response.headers().getDate("date");
      if (date != null) {
        TimeUtils.syncServerTime(date.getTime());
      }
    }

    return response;
  }
}
