package com.zoyi.channel.plugin.android.model.rest;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.text.TextUtils;

import com.zoyi.channel.plugin.android.enumerate.DayOfWeekType;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.com.annimon.stream.Stream;

import java.util.List;

/**
 * Created by mika on 2017. 1. 31..
 */
public class TimeRange {

  private final static int DAY_IN_MINUTES = 24 * 60;

  public TimeRange(@Nullable List<String> dayOfWeeks, @Nullable Integer from, @Nullable Integer to) {
    this.dayOfWeeks = dayOfWeeks;
    this.from = from;
    this.to = to;
  }

  public TimeRange(@Nullable List<String> dayOfWeeks, int fromHours, int fromMinutes, int toHours, int toMinutes) {
    this.dayOfWeeks = dayOfWeeks;
    this.from = fromHours * 60 + fromMinutes;
    this.to = toHours * 60 + toMinutes;
  }

  @Nullable
  private List<String> dayOfWeeks;
  @Nullable
  private Integer from;
  @Nullable
  private Integer to;

  @NonNull
  public List<DayOfWeekType> getDayOfWeeks() {
    return Stream.ofNullable(dayOfWeeks)
        .map(DayOfWeekType::fromString)
        .toList();
  }

  @Nullable
  public Integer getFrom() {
    return from;
  }

  @Nullable
  public Integer getTo() {
    return to;
  }

  public String getMessage() {
    String dayOfWeeksText = TextUtils.join(
        ", ",
        Stream.ofNullable(getDayOfWeeks())
            .sortBy(DayOfWeekType::getIndex)
            .map(DayOfWeekType::getString)
            .toList()
    );

    String time = TimeUtils.getTimeRangeString(this);

    return String.format("%s\n%s", dayOfWeeksText, time);
  }

  public boolean isValid() {
    return from != null && to != null && from < to && from >= 0 && from <= DAY_IN_MINUTES && to >= 0 && to <= DAY_IN_MINUTES;
  }
}
