package com.zoyi.channel.plugin.android.model.rest;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.zoyi.channel.plugin.android.model.entity.Entity;

public class Country implements Entity {

  @Nullable
  private String name;
  @Nullable
  private String code;
  @Nullable
  private Integer callingCode;

  public Country() {}

  @Nullable
  public String getName() {
    return name;
  }

  @Nullable
  public String getCode() {
    return code;
  }

  @NonNull
  public String getCallingCode() {
    if (callingCode != null) {
      return String.valueOf(callingCode);
    }
    return "";
  }

  @Override
  public String getId() {
    return code;
  }
}
