package com.zoyi.channel.plugin.android.model.error;

import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.util.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by mika on 2018. 7. 13..
 */

public class ExceptionResponse {

  private String type;
  private String status;
  private List<Error> errors;
  private Error error;

  @Nullable
  public String getMessage() {
    if (error != null) {
      return error.getMessage();
    }
    if (errors != null) {
      List<String> messages = new ArrayList<>();
      for (Error error : errors) {
        if (error != null) {
          String message = error.getMessage();
          if (message != null) {
            messages.add(message);
          }
        }
      }
      if (messages.size() > 0) {
        return StringUtils.join(messages, "\n");
      }
    }
    return null;
  }
}
