package com.zoyi.channel.plugin.android.global;

import androidx.annotation.Nullable;

import com.zoyi.channel.plugin.android.bind.*;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.subjects.PublishSubject;

public class RxBus {

  private static PublishSubject<Object> publishSubject = PublishSubject.create();

  public static void post(@Nullable Object object) {
    if (object != null) {
      publishSubject.onNext(object);
    }
  }

  public static Subscription subscribe(Action1<Object> action1) {
    return publishSubject.onBackpressureBuffer().observeOn(AndroidSchedulers.mainThread()).subscribe(action1);
  }

  public static Binder bind(Action1<Object> action1, BinderController controller) {
    return new SubscriptionBinder(publishSubject.onBackpressureBuffer().observeOn(AndroidSchedulers.mainThread()).subscribe(action1)).bind(controller);
  }
}
