package com.zoyi.channel.plugin.android.enumerate;

import androidx.annotation.Nullable;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.Const;

public enum ButtonTheme {

  BLUE(Const.MESSAGE_LINK_BUTTON_BLUE, R.color.ch_cobalt400),
  GREEN(Const.MESSAGE_LINK_BUTTON_GREEN, R.color.ch_green400),
  ORANGE(Const.MESSAGE_LINK_BUTTON_ORANGE, R.color.ch_orange400),
  RED(Const.MESSAGE_LINK_BUTTON_RED, R.color.ch_red400),
  UNKNOWN(null, R.color.ch_grey900);
  
  @Nullable
  private String theme;
  private int color;

  ButtonTheme(@Nullable String theme, int color) {
    this.theme = theme;
    this.color = color;
  }

  @Nullable
  public String getTheme() {
    return theme;
  }

  public int getColor() {
    return color;
  }

  public static ButtonTheme fromString(@Nullable String value) {
    if (value != null) {
      switch (value.toLowerCase()) {
        case Const.MESSAGE_LINK_BUTTON_BLUE:
          return BLUE;
        case Const.MESSAGE_LINK_BUTTON_GREEN:
          return GREEN;
        case Const.MESSAGE_LINK_BUTTON_ORANGE:
          return ORANGE;
        case Const.MESSAGE_LINK_BUTTON_RED:
          return RED;
      }
    }
    return UNKNOWN;
  }
}
