package com.zoyi.channel.plugin.android.deserializer;

import androidx.annotation.Nullable;
import android.text.TextUtils;

import com.zoyi.channel.plugin.android.model.etc.BlockParseResult;
import com.zoyi.channel.plugin.android.model.rest.NestedMessage;
import com.zoyi.channel.plugin.android.util.MessageUtils;
import com.zoyi.channel.plugin.android.util.message.MessageParseOptions;
import com.zoyi.channel.plugin.android.util.message.MessageParserUtils;
import com.zoyi.com.google.gson.*;

import java.lang.reflect.Type;

public class NestedMessageDeserializer implements JsonDeserializer {

  private Gson gson;
  private MessageParseOptions options;

  public NestedMessageDeserializer() {
    this.gson = new Gson();
    this.options = MessageUtils.getWelcomeMessageOption();
  }

  @Nullable
  private String getPlainText(NestedMessage nestedMessage, @Nullable BlockParseResult result) {
    if (result != null && !TextUtils.isEmpty(result.getPlainText())) {
      return result.getPlainText();
    }
    if (nestedMessage.getWebPage() != null) {
      return nestedMessage.getWebPage().getUrl();
    }
    return null;
  }

  @Override
  public Object deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
    NestedMessage nestedMessage = gson.fromJson(json, type);

    if (nestedMessage != null) {
      BlockParseResult result = MessageParserUtils.parseBlocks(nestedMessage.getBlocks(), options);

      nestedMessage.setPlainText(getPlainText(nestedMessage, result));
    }
    return nestedMessage;
  }
}
