package com.zoyi.channel.plugin.android.deserializer;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.AppMedia;
import com.zoyi.channel.plugin.android.model.rest.media.dummy.DummyMedia;
import com.zoyi.channel.plugin.android.model.rest.media.instagram.Instagram;
import com.zoyi.com.google.gson.*;

import java.lang.reflect.Type;

public class AppMediaDeserializer implements JsonDeserializer<AppMedia> {

  private Gson gson;

  public AppMediaDeserializer() {
    this.gson = new Gson();
  }

  @Override
  public AppMedia deserialize(
      JsonElement json,
      Type type,
      JsonDeserializationContext jsonDeserializationContext
  ) throws JsonParseException {
    JsonObject obj = json.getAsJsonObject();

    if (obj != null && obj.has("type")) {
      String appMediaType = obj.get("type").getAsString();

      if (appMediaType != null) {
        switch (appMediaType) {
          case Const.APP_MEDIA_INSTAGRAM:
            return gson.fromJson(json, Instagram.class);
        }
      }
    }
    return new DummyMedia();
  }
}
