package com.zoyi.channel.plugin.android.activity.settings.contract;

import com.zoyi.channel.plugin.android.contract.BasePresenter;
import com.zoyi.channel.plugin.android.contract.BaseView;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.model.rest.ProfileBotSchema;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.channel.plugin.android.open.option.Language;

import java.util.List;

public interface SettingsContract {

  interface View extends BaseView {

    void onLanguageChange(Language language);

    void onProfileBotSchemasFetchStateChange(FetchState state);

    void onProfileBotSchemasChange(List<ProfileBotSchema> profileBotSchemas, User user);

    void onUnsubscribedChanged(boolean unsubscribed);
  }

  interface Presenter extends BasePresenter {

    void fetchProfileBotSchema();
  }
}
