package com.zoyi.channel.plugin.android.activity.profile.view;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;

public class EditProfileStringView extends FrameLayout implements BaseEditProfileView {

  private WatchedEditText editText;
  private View clearButton;

  public EditProfileStringView(@NonNull Context context) {
    super(context);

    init(context);
  }

  public EditProfileStringView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);

    init(context);
  }

  public EditProfileStringView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);

    init(context);
  }

  @Initializer
  @Override
  public void init(Context context) {
    View root = LayoutInflater.from(context).inflate(R.layout.ch_view_edit_profile_string, this, true);

    editText = root.findViewById(R.id.ch_editEditProfileString);
    clearButton = root.findViewById(R.id.ch_buttonEditProfileStringClearText);

    editText.setWatchedTextChangedListener(s -> Views.setVisibility(clearButton, !TextUtils.isEmpty(s)));
    clearButton.setOnClickListener(v -> editText.setText(null));
  }

  @Override
  public void focus() {
    if (editText != null) {
      editText.requestFocus();
    }
  }

  @Override
  public boolean isValidValue() {
    return true;
  }

  @Nullable
  @Override
  public Object getValue() {
    if (editText != null) {
      return editText.getString();
    }
    return null;
  }

  @Override
  public void setValue(@Nullable Object value) {
    if (editText != null) {
      if (value != null) {
        editText.setText((String) value);
      } else {
        editText.setText(null);
      }
    }
  }
}
