package com.zoyi.channel.plugin.android.activity.profile.view;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.option.CheckView;

public class EditProfileBooleanView extends FrameLayout implements BaseEditProfileView {

  private CheckView checkViewTrue;
  private CheckView checkViewFalse;
  private CheckView checkViewNone;

  @Nullable
  private Boolean value;

  public EditProfileBooleanView(@NonNull Context context) {
    super(context);

    init(context);
  }

  public EditProfileBooleanView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);

    init(context);
  }

  public EditProfileBooleanView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);

    init(context);
  }

  @Initializer
  @Override
  public void init(Context context) {
    View root = LayoutInflater.from(context).inflate(R.layout.ch_view_edit_profile_boolean, this, true);

    checkViewTrue = root.findViewById(R.id.ch_checkEditProfileBooleanTrue);
    checkViewFalse = root.findViewById(R.id.ch_checkEditProfileBooleanFalse);
    checkViewNone = root.findViewById(R.id.ch_checkEditProfileBooleanNone);

    checkViewTrue.setOnClickListener(v -> setValue(true));
    checkViewFalse.setOnClickListener(v -> setValue(false));
    checkViewNone.setOnClickListener(v -> setValue(null));
  }

  @Override
  public void focus() {
  }

  @Override
  public boolean isValidValue() {
    return true;
  }

  @Nullable
  @Override
  public Object getValue() {
    return value;
  }

  @Override
  public void setValue(@Nullable Object value) {
    try {
      if (value == null) {
        this.value = null;
      } else if (value instanceof Boolean) {
        this.value = (Boolean) value;
      } else {
        this.value = Boolean.valueOf((String) value);
      }
    } catch (Exception ex) {
      this.value = null;
    }

    checkViewTrue.setChecked(this.value != null && this.value);
    checkViewFalse.setChecked(this.value != null && !this.value);
    checkViewNone.setChecked(this.value == null);
  }
}
