package com.zoyi.channel.plugin.android.activity.photo_picker;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

import android.view.LayoutInflater;
import android.view.ViewGroup;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.photo_picker.contract.PhotoPickerAdapterContract;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoItem;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.draw.Display;

import java.util.ArrayList;

/**
 * Created by mika on 8/31/16.
 */
class PhotoPickerAdapter
    extends RecyclerView.Adapter<PhotoHolder>
    implements PhotoPickerAdapterContract.View, PhotoPickerAdapterContract.Model {

  private Context context;
  @Nullable
  private OnPhotoClickListener listener;

  private ArrayList<PhotoItem> photoItems;
  private ArrayList<PhotoItem> selectedPaths;

  private int itemSize;
  private int itemMargin;

  PhotoPickerAdapter(Context context) {
    this.context = context;
    this.photoItems = new ArrayList<>();
    this.selectedPaths = new ArrayList<>();

    itemSize = Display.getWidth(context) / Const.COLUMNS_PHOTO_PICKER;
    itemMargin = (int) Utils.dpToPx(context, 2);
  }

  @Override
  public void setOnPhotoClickListener(OnPhotoClickListener listener) {
    this.listener = listener;
  }

  @Override
  public PhotoHolder onCreateViewHolder(ViewGroup parent, int viewType) {
    return new PhotoHolder(
        LayoutInflater.from(context).inflate(R.layout.ch_plugin_item_photo_picker, parent, false),
        itemSize,
        itemMargin,
        listener
    );
  }

  @Override
  public void onBindViewHolder(PhotoHolder holder, int position) {
    PhotoItem photoItem = photoItems.get(position);

    holder.setValue(photoItem, position, isExists(photoItem));
  }

  @Override
  public int getItemCount() {
    return photoItems.size();
  }

  @Override
  public void setPhotoItems(ArrayList<PhotoItem> photoItems) {
    this.photoItems = photoItems;

    notifyDataSetChanged();
  }

  @Override
  public boolean onPhotoItemClick(PhotoItem photoItem) {
    Uri uri = photoItem.getUri();
    int selectedIndex = getSelectedIndex(photoItem);

    if (uri != null) {
      if (selectedIndex >= 0) {
        selectedPaths.remove(selectedIndex);
        updatePhotoItem(photoItem);
      } else if (selectedPaths.size() < Const.PHOTO_SELECT_LIMIT) {
        selectedPaths.add(photoItem);
        updatePhotoItem(photoItem);
      } else {
        return false;
      }
    }
    return true;
  }

  private int getSelectedIndex(PhotoItem photoItem) {
    for (int i = 0; i < selectedPaths.size(); i++) {
      if (selectedPaths.get(i).getId() == photoItem.getId()) {
        return i;
      }
    }
    return -1;
  }

  private boolean isExists(PhotoItem photoItem) {
    return getSelectedIndex(photoItem) >= 0;
  }

  private void updatePhotoItem(PhotoItem photoItem) {
    for (int i = 0; i < photoItems.size(); i++) {
      if (photoItems.get(i).getId() == photoItem.getId()) {
        notifyItemChanged(i);
        break;
      }
    }
  }

  @Override
  public ArrayList<PhotoItem> getSelectedItems() {
    return selectedPaths;
  }
}
