package com.zoyi.channel.plugin.android.activity.photo_album;

import android.animation.Animator;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.graphics.Color;
import android.view.View;
import android.widget.ImageButton;
import android.widget.TextView;

import androidx.viewpager.widget.ViewPager;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.download.DownloadActivity;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.FileMeta;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoViewAttacher;
import com.zoyi.channel.plugin.android.view.layout.PhotoViewPager;
import com.zoyi.com.annimon.stream.Stream;

import java.util.*;

/**
 * Created by mika on 2017. 1. 11..
 */
public class PhotoAlbumActivity extends BaseActivity2
    implements View.OnClickListener, PhotoViewAttacher.OnPhotoTapListener {

  private static final int ANIMATION_DURATION = 200;

  private View layoutOverlay;
  private TextView pageInfoText;
  private ImageButton downloadButton;
  private ImageButton copyLinkButton;
  private ImageButton closeButton;

  private boolean menuVisible = true;

  private PhotoViewPager viewPager;
  private PhotoAlbumPagerAdapter adapter;

  @Initializer
  @Override
  protected boolean onCreate() {
    init(R.layout.ch_plugin_activity_photo_album, Color.BLACK, false);

    layoutOverlay = findViewById(R.id.ch_layoutPhotoAlbumImage);
    viewPager = findViewById(R.id.ch_viewPagerPhotoAlbum);
    pageInfoText = findViewById(R.id.ch_textPhotoAlbumPageInfo);
    copyLinkButton = findViewById(R.id.ch_buttonPhotoAlbumCopyLink);
    downloadButton = findViewById(R.id.ch_buttonPhotoAlbumDownload);
    closeButton = findViewById(R.id.ch_buttonPhotoAlbumClose);

    downloadButton.setOnClickListener(this);
    copyLinkButton.setOnClickListener(this);
    closeButton.setOnClickListener(this);

    Integer storageId = getInteger(Const.EXTRA_STORAGE_ID);
    String attachmentId = getString(Const.EXTRA_ATTACHMENT_ID);

    adapter = new PhotoAlbumPagerAdapter(this, this);

    if (storageId == null || attachmentId == null) {
      return false;
    }

    List<FileMeta> fileMetas = Stream.ofNullable(PhotoAlbumStorage.getInstance().get(storageId))
        .filter(file -> file != null)
        .map(file -> (FileMeta) file)
        .toList();

    if (fileMetas != null && fileMetas.size() > 0) {
      int initIndex = findInitIndex(fileMetas, attachmentId);

      adapter.setItems(fileMetas);

      viewPager.setAdapter(adapter);
      viewPager.setCurrentItem(initIndex);
      viewPager.addOnPageChangeListener(new ViewPager.SimpleOnPageChangeListener() {
        boolean init = true;

        @Override
        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
          if (init && positionOffset == 0f && positionOffsetPixels == 0) {
            onPageSelected(position);
            init = false;
          }

          if (adapter != null) {
            pageInfoText.setText((position + 1) + " / " + adapter.getCount());
          }
        }
      });
      return true;
    }
    return false;
  }

  @Override
  public void onClick(View view) {
    int id = view.getId();

    if (id == R.id.ch_buttonPhotoAlbumClose) {
      finish();
    }
    if (id == R.id.ch_buttonPhotoAlbumCopyLink) {
      copyLink();
    }
    if (id == R.id.ch_buttonPhotoAlbumDownload) {
      download();
    }
  }

  private void copyLink() {
    FileMeta fileMeta = adapter.getItem(viewPager.getCurrentItem());
    if (fileMeta != null) {
      try {
        ClipboardManager clipboard = (ClipboardManager) getSystemService(CLIPBOARD_SERVICE);
        ClipData clip = ClipData.newPlainText("text", fileMeta.getUrl());
        clipboard.setPrimaryClip(clip);

        UIUtils.showToast(this, ResUtils.getString(this, "ch.photo.url_copied_to_clipboard"));
      } catch (Exception ex) {
        UIUtils.showToast(this, ResUtils.getString(this, "ch.photo.read_file_info_failed"));
      }
    }
  }

  private void download() {
    FileMeta fileMeta = adapter.getItem(viewPager.getCurrentItem());
    if (fileMeta != null) {
      IntentUtils.setNextActivity(this, DownloadActivity.class)
          .putExtra(Const.EXTRA_URL, fileMeta.getUrl())
          .putExtra(Const.EXTRA_FILE_NAME, fileMeta.getName())
          .putExtra(Const.EXTRA_TYPE, Const.FILE_TYPE_IMAGE)
          .setTransition(Transition.NONE)
          .startActivity();
    }
  }

  public int findInitIndex(List<FileMeta> fileMetas, String attachmentId) {
    for (int i = 0; i < fileMetas.size(); i++) {
      if (fileMetas.get(i).getId().equals(attachmentId)) {
        return i;
      }
    }
    return 0;
  }

  @Override
  public void onPhotoTap(View view, float x, float y) {
    animateOverlay();
  }

  @Override
  public void onOutsidePhotoTap() {
    animateOverlay();
  }

  private void animateOverlay() {
    layoutOverlay.animate()
        .alpha(menuVisible ? 0f : 1f)
        .setDuration(ANIMATION_DURATION)
        .setListener(animatorListener).start();
  }

  private Animator.AnimatorListener animatorListener = new Animator.AnimatorListener() {
    @Override
    public void onAnimationStart(Animator animator) {
      menuVisible = !menuVisible;

      if (menuVisible) {
        layoutOverlay.setVisibility(View.VISIBLE);
      }
    }

    @Override
    public void onAnimationEnd(Animator animator) {
      layoutOverlay.setVisibility(menuVisible ? View.VISIBLE : View.GONE);
    }

    @Override
    public void onAnimationCancel(Animator animator) {
    }

    @Override
    public void onAnimationRepeat(Animator animator) {
    }
  };
}
