package com.zoyi.channel.plugin.android.activity.lounge.view.app_messenger.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.text.TextUtils;
import android.widget.ImageView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.lounge.view.app_messenger.OnIntegrationClickListener;
import com.zoyi.channel.plugin.android.model.entity.Contact;
import com.zoyi.channel.plugin.android.util.FormatUtils;

public class PhoneContact implements Contact {

  @NonNull
  private final String number;

  public PhoneContact(@NonNull String number) {
    this.number = number;
  }

  @Nullable
  @Override
  public String getTitle() {
    return "전화 걸기???";
  }

  @Nullable
  @Override
  public String getDescription() {
    String mobileNumberFormat = FormatUtils.formatMobileNumber(number);

    if (!TextUtils.isEmpty(mobileNumberFormat)) {
      return FormatUtils.formatMobileNumber(number);
    }
    return number;
  }

  @Override
  public void setIcon(ImageView imageView) {
    imageView.setImageResource(R.drawable.ch_plugin_integration_phone);
  }

  @Override
  public void doAction(@Nullable OnIntegrationClickListener listener) {
    if (listener != null) {
      listener.onCallClick(number);
    }
  }
}
