package com.zoyi.channel.plugin.android.activity.lounge.view.app_messenger;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.entity.Contact;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.com.bumptech.glide.Glide;

public class LoungeAppButtonView extends FrameLayout {

  private Context context;

  private ImageView imageButtonIcon;

  @Nullable
  private Contact item;

  @Nullable
  private OnIntegrationClickListener listener;

  public LoungeAppButtonView(@NonNull Context context, @Nullable Contact item, @Nullable OnIntegrationClickListener listener) {
    super(context);
    init(context, item, listener);
  }

  @Initializer
  protected void init(Context context, @Nullable Contact item, @Nullable OnIntegrationClickListener listener) {
    this.context = context;
    this.item = item;
    this.listener = listener;

    View root = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_lounge_app, this);
    root.setOnClickListener(view -> {
      if (item != null) {
        item.doAction(listener);
      }
    });

    imageButtonIcon = root.findViewById(R.id.ch_imageButtonIcon);
    setIcon();
  }

  private void setIcon() {
    if (item != null) {
      item.setIcon(imageButtonIcon);
    }
  }

  @Override
  protected void onDetachedFromWindow() {
    Glide.clear(imageButtonIcon);
    super.onDetachedFromWindow();
  }
}
