package com.zoyi.channel.plugin.android.activity.common.watermark;

import android.content.Context;
import android.graphics.Color;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.util.*;

public class ChannelWatermarkView extends FrameLayout {

  private Context context;

  private View root;
  private View borderView;

  @Nullable
  private Binder binder;

  @Nullable
  private String link;

  public ChannelWatermarkView(@NonNull Context context) {
    super(context);
    init(context);
  }

  public ChannelWatermarkView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public ChannelWatermarkView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  @Initializer
  private void init(Context context) {
    this.context = context;

    root = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_channel_watermark, this, true);
    borderView = root.findViewById(R.id.ch_viewWatermarkBorder);

    root.setBackgroundColor(Color.TRANSPARENT);

    root.setOnClickListener(v -> {
      if (link != null) {
        IntentUtils.setUrl(ChannelWatermarkView.this.context, link).startActivity();
      }
    });
  }

  @Override
  protected void onAttachedToWindow() {
    super.onAttachedToWindow();

    if (this.getVisibility() == View.VISIBLE) {
      binder = ChannelSelector.bindChannel(channel -> {
        Views.setVisibility(root, !channel.isWhiteLabelFeature());

        link = String.format(
            Const.UTM_URL,
            SettingsStore.get().language.get().toString(),
            Const.UTM_PATH_WATERMARK,
            channel.getName(),
            channel.getId()
        );
      });
    }
  }

  @Override
  protected void onDetachedFromWindow() {
    super.onDetachedFromWindow();

    if (binder != null) {
      binder.unbind();
    }
  }

  public void setBorderVisibility(boolean visibility) {
    borderView.setVisibility(visibility ? View.VISIBLE : View.INVISIBLE);
  }
}
