package com.zoyi.channel.plugin.android.activity.common.userchat.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.store.ChannelStore;
import com.zoyi.com.annimon.stream.Optional;

import java.util.ArrayList;
import java.util.List;

public class UserChatItem implements ChatItem {

  private UserChat userChat;
  @Nullable
  private Message message;
  @Nullable
  private Session session;
  @Nullable
  private ProfileEntity profileEntity;

  public UserChatItem(UserChat userChat, @Nullable Message message, @Nullable Session session, @Nullable ProfileEntity profileEntity) {
    this.userChat = userChat;
    this.message = message;
    this.session = session;
    this.profileEntity = profileEntity;
  }

  @Nullable
  @Override
  public String getId() {
    if (userChat != null) {
      return userChat.getId();
    }
    return null;
  }

  @Nullable
  @Override
  public ProfileEntity getProfile() {
    if (profileEntity != null) {
      return profileEntity;
    }
    return ChannelStore.get().channelState.get();
  }

  @Nullable
  @Override
  public Long getUpdatedAt() {
    if (userChat != null && userChat.isStateClosed() && userChat.getClosedAt() != null) {
      return userChat.getClosedAt();
    }
    if (userChat != null && userChat.getUpdatedAt() != null) {
      return userChat.getUpdatedAt();
    }
    return null;
  }

  @Nullable
  @Override
  public String getState() {
    return Optional.ofNullable(message).map(Message::getState).orElse(null);
  }

  @Override
  public boolean isDelete() {
    return Optional.ofNullable(message).map(Message::isDeleted).orElse(false);
  }

  @Override
  public boolean hasReview() {
    return Optional.ofNullable(userChat).map(uc -> uc.getReview() != null).orElse(false);
  }

  @Override
  public boolean requestReview() {
    return Optional.ofNullable(message)
        .map(Message::getAction)
        .map(MessageAction::getType)
        .map(Const.ACTION_TYPE_CLOSE::equals)
        .orElse(false);
  }

  @Override
  public boolean isClosed() {
    return Optional.ofNullable(userChat).map(UserChat::isStateClosed).orElse(false);
  }

  @NonNull
  @Override
  public List<File> getFiles() {
    return Optional.ofNullable(message).map(Message::getFiles).orElse(new ArrayList<>());
  }

  @NonNull
  @Override
  public List<Button> getLinkButtons() {
    return Optional.ofNullable(message).map(Message::getButtons).orElse(new ArrayList<>());
  }

  @Nullable
  @Override
  public String getPlainText() {
    return Optional.ofNullable(message)
        .map(Message::getPlainText)
        .filter(it -> !it.isEmpty())
        .orElse(null);
  }

  @Override
  public int getAlert() {
    if (session != null && session.getAlert() != null) {
      return session.getAlert();
    }
    return 0;
  }

  @Nullable
  @Override
  public String getSubKey() {
    if (userChat != null) {
      return userChat.getId();
    }
    return null;
  }

  @Override
  public ChatContentType getType() {
    return ChatContentType.USER_CHAT;
  }
}
