package com.zoyi.channel.plugin.android.activity.common.navigation;

import android.content.Context;
import androidx.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.selector.BootDataSelector;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.util.ComponentUtils;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.button.ThemeEffectiveView;
import com.zoyi.channel.plugin.android.view.textview.CHTextView;

public class ChannelInfoNavigationView extends LinearLayout implements ThemeEffectiveView {

  private CHTextView textChannelName;
  private CHTextView textDescription;
  private ImageView imageChannelStatus;

  @Nullable
  private Binder dataBinder;

  public ChannelInfoNavigationView(Context context) {
    super(context);
    init(context, null);
  }

  public ChannelInfoNavigationView(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context, attrs);
  }

  public ChannelInfoNavigationView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context, attrs);
  }

  @Initializer
  private void init(Context context, @Nullable AttributeSet attrs) {
    View root = LayoutInflater.from(context).inflate(R.layout.ch_plugin_navigation_channel_info, this, true);

    textChannelName = root.findViewById(R.id.ch_textNavigationChannelName);
    textDescription = root.findViewById(R.id.ch_textNavigationDescription);
    imageChannelStatus = root.findViewById(R.id.ch_imageNavigationChannelStatus);
  }

  @Override
  protected void onAttachedToWindow() {
    super.onAttachedToWindow();

    dataBinder = BootDataSelector.bindBootData((plugin, channel, isWorking) -> {
      textChannelName.setText(channel.getName());
      textDescription.setText(ComponentUtils.getShortResponseDescription(channel, isWorking));

      imageChannelStatus.setImageResource(ComponentUtils.getResponseSymbol(plugin, channel, isWorking == 0));
    });
  }

  @Override
  protected void onDetachedFromWindow() {
    super.onDetachedFromWindow();

    if (dataBinder != null) {
      dataBinder.unbind();
    }
  }

  @Override
  public void onThemeChange(int backColor, int textColor) {
    textChannelName.setTextColor(textColor);
    textDescription.setTextColor(textColor);
  }
}
