package com.zoyi.channel.plugin.android.activity.common.badge;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.Utils;

public class AlertBadge extends FrameLayout {

  private TextView textBadge;

  public AlertBadge(@NonNull Context context) {
    super(context);
    init(context);
  }

  public AlertBadge(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public AlertBadge(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  @Initializer
  private void init(Context context) {
    View root = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_alert_badge, this, true);

    textBadge = root.findViewById(R.id.ch_textAlertBadge);
  }

  public void setTheme(int backColor, int textColor) {
    textBadge.setBackgroundColor(textColor);
    textBadge.setTextColor(backColor);
  }

  public void setCount(int count) {
    textBadge.setText(Utils.getCount(count, true));
  }
}
