package com.zoyi.channel.plugin.android.activity.chats;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SortedList;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.activity.chats.contract.ChatsAdapterContract;
import com.zoyi.channel.plugin.android.activity.common.userchat.callback.ChatListCallback;
import com.zoyi.channel.plugin.android.activity.common.userchat.listener.OnChatClickListener;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.ChatItem;
import com.zoyi.channel.plugin.android.activity.common.userchat.viewholder.ChatHolder;

import java.util.List;

public class ChatsAdapter extends RecyclerView.Adapter<ChatHolder> implements ChatsAdapterContract.View, ChatsAdapterContract.Model {

  @NonNull
  private SortedList<ChatItem> items;

  @Nullable
  private OnChatClickListener listener;

  public ChatsAdapter() {
    this.items = new SortedList<>(ChatItem.class, new ChatListCallback(this));
  }

  public void setListener(@Nullable OnChatClickListener listener) {
    this.listener = listener;
  }

  @Override
  public void updateChatItems(List<ChatItem> items) {
    this.items.replaceAll(items);
  }

  @NonNull
  @Override
  public ChatHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
    return ChatHolder.newInstance(parent, listener);
  }

  @Override
  public void onBindViewHolder(@NonNull ChatHolder holder, int position) {
    holder.bind(items.get(position));
  }

  @Override
  public int getItemCount() {
    return this.items.size();
  }
}
