package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;

import com.zoyi.channel.plugin.android.activity.chat.listener.viewholder.OnBaseMessageActionListener;
import com.zoyi.channel.plugin.android.activity.chat.model.SupportBotMessageItem;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.ActionButton;
import com.zoyi.com.annimon.stream.Optional;

public class SupportBotMessageHolder extends AbsHostMessageHolder {

  @Nullable
  private OnBaseMessageActionListener listener;

  @Nullable
  private SupportBotMessageItem item;

  private SupportBotMessageHolder(View itemView, @Nullable OnBaseMessageActionListener listener) {
    super(itemView, listener);

    this.listener = listener;
  }

  public void bind(SupportBotMessageItem item, boolean isLast) {
    super.bind(item.getDefaultBot(), item.getCreatedAt(), true, true, true);

    this.item = item;

    setBlocks(item.getBlocks());

    // set web page
    Optional.ofNullable(item.getWebPage()).ifPresent(webPage -> setWebPage(String.valueOf(item.getCreatedAt()), webPage));

    setAttachments(String.valueOf(item.getId()), item.getFiles(), this);

    if (item.getLinkButtons() != null) {
      setLinkButtons(item.getLinkButtons());
    }

    if (item.getButtons() != null && isLast) {
      setActionButtons(Const.ACTION_TYPE_SUPPORT_BOT, item.getButtons());
    } else {
      setActionButtons(null, null);
    }
  }

  @Override
  public void onActionButtonClick(@NonNull String actionType, @NonNull ActionButton actionButton) {
    if (this.listener != null && this.item != null && Const.ACTION_TYPE_SUPPORT_BOT.equals(actionType)) {
      listener.onLocalSupportBotActionClick(this.item.getId(), actionType, actionButton);
    }
  }

  @Override
  protected void onRecycled() {
    super.onRecycled();

    this.item = null;
  }


  public static SupportBotMessageHolder newInstance(ViewGroup parent, @Nullable OnBaseMessageActionListener listener) {
    return new SupportBotMessageHolder(getItemView(parent), listener);
  }
}
