package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import androidx.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.activity.chat.model.SendTextItem;
import com.zoyi.channel.plugin.android.activity.chat.listener.viewholder.OnSendingActionListener;

public class SendingTextMessageHolder extends AbsSendingMessageHolder {

  private SendingTextMessageHolder(View itemView, @Nullable OnSendingActionListener listener) {
    super(itemView, listener);
  }

  public void bind(SendTextItem item, boolean isTail) {
    super.bind(item, isTail);

    setText(item.getText());
  }

  public static SendingTextMessageHolder newInstance(ViewGroup parent, @Nullable OnSendingActionListener listener) {
    return new SendingTextMessageHolder(getItemView(parent), listener);
  }
}
