package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import androidx.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;

import com.zoyi.channel.plugin.android.activity.chat.model.SendActionItem;
import com.zoyi.channel.plugin.android.activity.chat.listener.viewholder.OnSendingActionListener;
import com.zoyi.channel.plugin.android.model.rest.ActionButton;
import com.zoyi.channel.plugin.android.util.message.MessageParserUtils;
import com.zoyi.com.annimon.stream.Optional;

public class SendingActionMessageHolder extends AbsSendingMessageHolder {

  private SendingActionMessageHolder(View itemView, @Nullable OnSendingActionListener listener) {
    super(itemView, listener);
  }

  public void bind(SendActionItem item) {
    super.bind(item, false);

    setText(
        Optional.ofNullable(item.getActionButton())
            .map(ActionButton::getText)
            .map(text -> MessageParserUtils.parseText(text).toString())
            .orElse(null)
    );
  }

  public static SendingActionMessageHolder newInstance(ViewGroup parent, @Nullable OnSendingActionListener listener) {
    return new SendingActionMessageHolder(getItemView(parent), listener);
  }
}
