package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.view.*;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.viewholder.OnProfileBotSubmitListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.viewholder.OnProfileUpdateRequestListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ProfileBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.view.profilebot.*;
import com.zoyi.channel.plugin.android.activity.chat.view.viewholder.ProfileBotCompleteView;
import com.zoyi.channel.plugin.android.base.adapter.BaseViewHolder;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.rest.ProfileBot;
import com.zoyi.channel.plugin.android.open.option.Language;
import com.zoyi.channel.plugin.android.store.*;
import com.zoyi.channel.plugin.android.util.*;

import java.util.Locale;

public class ProfileBotMessageHolder extends BaseViewHolder implements OnProfileBotSubmitListener {

  private LinearLayout layoutCompleteItems;
  private View layoutProfileBotInput;

  private TextView textInputName;
  private TextView textInputProgressPage;
  private TextView textInputProgressTotalPages;
  private TextView textInputError;

  private ProfileBotInputBooleanView inputBooleanView;
  private ProfileBotInputDateView inputDateView;
  private ProfileBotInputMobileNumberView inputMobileNumberView;
  private ProfileBotInputNumberView inputNumberView;
  private ProfileBotInputStringView inputStringView;

  @Nullable
  private BaseProfileBotInputView inputView;

  private TextView textTerms;

  @Nullable
  private ProfileBotMessageItem item;

  @Nullable
  private OnProfileUpdateRequestListener listener;

  public ProfileBotMessageHolder(@NonNull View itemView, @Nullable OnProfileUpdateRequestListener listener) {
    super(itemView);

    this.listener = listener;

    layoutCompleteItems = itemView.findViewById(R.id.ch_layoutProfileBotItemCompleteItems);
    layoutProfileBotInput = itemView.findViewById(R.id.ch_layoutProfileBotItemInput);

    textInputName = itemView.findViewById(R.id.ch_textProfileBotItemLabel);
    textInputProgressPage = itemView.findViewById(R.id.ch_textProfileBotItemPage);
    textInputProgressTotalPages = itemView.findViewById(R.id.ch_textProfileBotItemTotalPages);
    textInputError = itemView.findViewById(R.id.ch_textProfileBotInputError);

    inputBooleanView = itemView.findViewById(R.id.ch_viewProfileBotInputBoolean);
    inputBooleanView.setListener(this);

    inputDateView = itemView.findViewById(R.id.ch_viewProfileBotInputDate);
    inputDateView.setListener(this);

    inputMobileNumberView = itemView.findViewById(R.id.ch_viewProfileBotInputMobileNumber);
    inputMobileNumberView.setListener(this);

    inputNumberView = itemView.findViewById(R.id.ch_viewProfileBotInputNumber);
    inputNumberView.setListener(this);

    inputStringView = itemView.findViewById(R.id.ch_viewProfileBotInputString);
    inputStringView.setListener(this);

    textTerms = itemView.findViewById(R.id.ch_textProfileBotItemTerms);
    textTerms.setText(Utils.getHtmlFormattedText(ResUtils.getString("ch.agreement")));
    textTerms.setOnClickListener(v -> {
      Plugin plugin = PluginStore.get().pluginState.get();
      Language language = SettingsStore.get().language.get();

      if (plugin != null && plugin.getKey() != null) {
        IntentUtils.setUrl(
            itemView.getContext(),
            String.format("https://channel.io/%s/terms_user?plugin_key=%s", language.toString(), plugin.getKey())
        ).startActivity();
      } else {
        IntentUtils.setUrl(
            itemView.getContext(),
            String.format("https://channel.io/%s/terms_user", language.toString())
        ).startActivity();
      }
    });
  }

  public void bind(ProfileBotMessageItem item) {
    this.item = item;

    // ignore null case (not necessary)
    if (item == null) {
      return;
    }

    ProfileBot inputProfileBot = null;
    int inputPageIndex = -1;

    for (int i = 0; i < item.getProfileBots().size(); i++) {
      ProfileBot profileBot = item.getProfileBots().get(i);

      if (profileBot == null || profileBot.getKey() == null) {
        continue;
      }

      // complete scheme
      if (profileBot.getValue() != null) {
        if (i < layoutCompleteItems.getChildCount()) {
          View view = layoutCompleteItems.getChildAt(i);

          if (view instanceof ProfileBotCompleteView) {
            view.setVisibility(View.VISIBLE);
            ((ProfileBotCompleteView) view).bind(profileBot);
          }
        } else {
          ProfileBotCompleteView view = new ProfileBotCompleteView(itemView.getContext());
          view.bind(profileBot);

          layoutCompleteItems.addView(view);
        }
      } else {
        inputProfileBot = profileBot;
        inputPageIndex = i;

        // hide overflow complete view (maybe not used)

        for (int index = i; i < layoutCompleteItems.getChildCount(); i++) {
          layoutCompleteItems.getChildAt(index).setVisibility(View.GONE);
        }

        break;
      }
    }

    // terms only show in first profile bot input
    textTerms.setVisibility(inputPageIndex == 0 ? View.VISIBLE : View.GONE);

    if (inputProfileBot != null) {
      layoutProfileBotInput.setVisibility(View.VISIBLE);

      textInputName.setText(inputProfileBot.getName());
      textInputProgressPage.setText(String.valueOf(inputPageIndex + 1));
      textInputProgressTotalPages.setText(String.format(Locale.US, "/%d", item.getProfileBots().size()));

      String prevKey = ProfileBotStore.get().inputKey.get();

      boolean isRestored = prevKey != null && prevKey.equals(inputProfileBot.getKey());
      boolean requestFocus = isRestored ? ProfileBotStore.get().requestFocus.get() : true;
      Object restoreValue = isRestored ? ProfileBotStore.get().inputValue.get() : null;
      FetchState fetchState = isRestored ? ProfileBotStore.get().requestState.get() : FetchState.COMPLETE;
      String inputError = isRestored && fetchState == FetchState.FAILED ? ProfileBotStore.get().inputError.get() : null;

      inputBooleanView.setVisibility(View.GONE);
      inputDateView.setVisibility(View.GONE);
      inputMobileNumberView.setVisibility(View.GONE);
      inputNumberView.setVisibility(View.GONE);
      inputStringView.setVisibility(View.GONE);

      if (inputError != null) {
        textInputError.setVisibility(View.VISIBLE);
        textInputError.setText(inputError);
      } else {
        textInputError.setVisibility(View.GONE);
      }

      if (Const.PROFILE_MOBILE_NUMBER_KEY.equals(inputProfileBot.getKey())) {
        bindInputView(inputMobileNumberView, inputProfileBot.getKey(), restoreValue, requestFocus, fetchState);
      } else {
        String type = inputProfileBot.getType() != null ? inputProfileBot.getType() : "";

        switch (type) {
          case Const.PROFILE_TYPE_BOOLEAN:
            bindInputView(inputBooleanView, inputProfileBot.getKey(), restoreValue, requestFocus, fetchState);
            break;

          case Const.PROFILE_TYPE_DATE:
            bindInputView(inputDateView, inputProfileBot.getKey(), restoreValue, requestFocus, fetchState);
            break;

          case Const.PROFILE_TYPE_NUMBER:
            bindInputView(inputNumberView, inputProfileBot.getKey(), restoreValue, requestFocus, fetchState);
            break;

          default:
            bindInputView(inputStringView, inputProfileBot.getKey(), restoreValue, requestFocus, fetchState);
            break;
        }
      }
    } else {
      this.inputView = null;

      layoutProfileBotInput.setVisibility(View.GONE);

      ProfileBotStore.get().requestFocus.set(false);
    }
  }

  private void bindInputView(
      BaseProfileBotInputView inputView,
      String key,
      @Nullable Object value,
      boolean requestFocus,
      FetchState fetchState
  ) {
    this.inputView = inputView;

    inputView.setVisibility(View.VISIBLE);
    inputView.setValue(key, value, fetchState);

    if (requestFocus) {
      inputView.focus();
    }
  }

  @Override
  public void onSubmit(String key, @Nullable Object value) {
    if (this.item != null && this.listener != null) {
      this.listener.onProfileRequest(item, key, value);
    }
  }

  @Override
  public void onRecycled() {
    super.onRecycled();

    if (this.inputView != null) {
      this.inputView.onRecycled();
      this.inputView = null;
    }
  }

  public static ProfileBotMessageHolder newInstance(ViewGroup parent, @Nullable OnProfileUpdateRequestListener listener) {
    LayoutInflater inflater = LayoutInflater.from(parent.getContext());

    return new ProfileBotMessageHolder(
        inflater.inflate(R.layout.ch_plugin_item_message_profile_bot, parent, false),
        listener
    );
  }
}
