package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.app.Dialog;
import androidx.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;

import com.zoyi.channel.plugin.android.activity.chat.listener.viewholder.OnMessageActionListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.com.annimon.stream.Optional;

public class HostMessageHolder extends AbsHostMessageHolder {

  @Nullable
  private Message message;

  @Nullable
  private OnMessageActionListener listener;

  private HostMessageHolder(View itemView, @Nullable OnMessageActionListener listener) {
    super(itemView, listener);

    this.listener = listener;
  }

  public void bind(ChatMessageItem item, boolean showDate, boolean isHead, boolean isTail, boolean isLast) {
    super.bind(item.getMessage(), item.getCreatedAt(), showDate, isHead, isTail);

    this.message = item.getMessage();

    String messageId = Optional.ofNullable(item.getMessage()).map(Message::getId).orElse(null);

    Message message = item.getMessage();
    // set text
    if (message != null) {
      if (message.isDeleted()) {
        setDeleteMessage();
      } else {
        setBlockMessage(message);

        if (message.getButtons() != null) {
          setLinkButtons(message.getButtons());
        }

        // set web page
        Optional.ofNullable(message.getWebPage()).ifPresent(webPage -> setWebPage(messageId, webPage));

        // set actions
        MessageAction action = message.getAction();

        if (isLast && action != null) {
          setActionButtons(action.getType(), action.getButtons());
        } else {
          setActionButtons(null, null);
        }

        setAttachments(message.getId(), message.getFiles(), this);
        setReactions(message.getReactions());
      }
    }
  }

  private void setBlockMessage(Message message) {
    if (message.getLanguage() != null
        && !message.getLanguage().equals(SettingsStore.get().language.get().toString())
        && SettingsStore.get().showTranslation.get()
    ) {
      setTranslation(
          message.getChatId(),
          message.getId(),
          SettingsStore.get().language.get().toString(),
          message.getBlocks()
      );
    } else if (message.getBlocks() != null && message.getBlocks().size() == 1 && message.getBlocks().get(0).hasOnlyEmoji()) {
      setGiantEmoji(message.getBlocks().get(0));
    } else {
      setBlocks(message.getBlocks());
    }
  }

  public static HostMessageHolder newInstance(ViewGroup parent, @Nullable OnMessageActionListener listener) {
    return new HostMessageHolder(getItemView(parent), listener);
  }

  @Override
  public boolean onLongClick(View v) {
    if (listener != null && message != null) {
      Dialog dialog = listener.onMessageLongClick(message);
      if (dialog != null) {
        dialog.show();
        return true;
      }
    }
    return false;
  }

  @Override
  public void onWebPageLongClick() {
    if (listener != null && message != null) {
      Dialog dialog = listener.onMessageLongClick(message);
      if (dialog != null) {
        dialog.show();
      }
    }
  }

  @Override
  public void onAttachmentClick(File attachment) {
    super.onAttachmentClick(attachment);

    if (listener != null && message != null) {
      listener.onAttachmentClick(attachment, message);
    }
  }

  @Override
  public void onAttachmentLongClick() {
    if (listener != null && message != null) {
      Dialog dialog = listener.onMessageLongClick(message);
      if (dialog != null) {
        dialog.show();
      }
    }
  }

  @Override
  public void onLinkButtonLongClick() {
    if (listener != null && message != null) {
      Dialog dialog = listener.onMessageLongClick(message);
      if (dialog != null) {
        dialog.show();
      }
    }
  }

  @Override
  protected void onReactionsLongClicked() {
    if (listener != null && message != null && message.getReactions() != null && message.getReactions().size() > 0) {
      listener.onReactionsLongClicked(message.getReactions());
    }
  }

  @Nullable
  @Override
  protected Marketing getMarketing() {
    return Optional.ofNullable(message).map(Message::getMarketing).orElse(null);
  }

  @Override
  protected void onRecycled() {
    super.onRecycled();

    this.message = null;
  }
}
