package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import androidx.annotation.Nullable;
import android.view.View;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.base.adapter.BaseViewHolder;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.channel.plugin.android.util.*;
import com.zoyi.rx.Subscription;

public abstract class AbsMessageHolder extends BaseViewHolder {

  private final static Long cutOff = 24L * 60L * 60L * 1000L;

  private View viewHead;
  private View viewTail;

  private TextView textDate;
  private TextView textCreatedAt;

  @Nullable
  private Subscription subscription;

  AbsMessageHolder(View itemView) {
    super(itemView);

    viewHead = itemView.findViewById(R.id.ch_layoutMessageHolderHead);
    viewTail = itemView.findViewById(R.id.ch_viewMessageHolderTailPadding);

    textDate = itemView.findViewById(R.id.ch_textMessageHolderDate);
    textCreatedAt = itemView.findViewById(R.id.ch_textMessageHolderTime);
  }

  public void bind(Long createdAt, boolean showDate, boolean isHead, boolean isTail) {
    clearSubscription();

    Views.setVisibility(viewHead, isHead);
    Views.setVisibility(viewTail, isTail);

    textCreatedAt.setText(TimeUtils.getTime(createdAt));

    if (textDate != null && showDate && createdAt != null) {
      textDate.setVisibility(View.VISIBLE);

      if (TimeUtils.isSameDate(createdAt)) {
        textDate.setText(ResUtils.getString("ch.day_divider.today"));

        subscription = TimeUtils.wait(TimeUtils.calculateUntilTomorrow(), () -> {
          textDate.setText(TimeUtils.formatTranslatedDate(createdAt, SettingsStore.get().language.get()));
        });
      } else {
        textDate.setText(TimeUtils.formatTranslatedDate(createdAt, SettingsStore.get().language.get()));
      }
    } else if (textDate != null) {
      textDate.setVisibility(View.GONE);
    }
  }

  @Override
  protected void onRecycled() {
    super.onRecycled();

    clearSubscription();
  }

  private void clearSubscription() {
    if (subscription != null && !subscription.isUnsubscribed()) {
      subscription.unsubscribe();
    }
    subscription = null;
  }
}
