package com.zoyi.channel.plugin.android.activity.chat.view.viewholder;

import android.content.Context;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;

import android.util.AttributeSet;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.contentview.OnWebPageContentActionListener;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.WebPage;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.media_thumbnail.WebPageMediaThumbnailView;

import java.util.Locale;

public class WebPageContentView extends ConstraintLayout implements MessageContentView, View.OnClickListener {

  public WebPageContentView(Context context) {
    super(context);

    init(context);
  }

  public WebPageContentView(Context context, AttributeSet attrs) {
    super(context, attrs);

    init(context);
  }

  public WebPageContentView(Context context, AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);

    init(context);
  }

  private ConstraintLayout rootMessageWebPage;
  private WebPageMediaThumbnailView thumbnailMessageWebPage;
  private View layoutMessageWebPageMeta;
  private TextView textMessageWebPageTitle;
  private TextView textMessageWebPageDescription;
  private View layoutMessageWebPagePublisher;
  private ImageView iconMessageWebPagePublisher;
  private TextView textMessageWebPagePublisher;

  @Nullable
  private OnWebPageContentActionListener listener;

  @Nullable
  private WebPage webPage;

  @Initializer
  private void init(Context context) {
    LayoutInflater.from(context).inflate(R.layout.ch_holder_message_content_web_page, this);

    rootMessageWebPage = findViewById(R.id.ch_rootMessageWebPage);
    textMessageWebPageTitle = findViewById(R.id.ch_textMessageWebPageTitle);
    textMessageWebPageDescription = findViewById(R.id.ch_textMessageWebPageDescription);
    layoutMessageWebPagePublisher = findViewById(R.id.ch_layoutMessageWebPagePublisher);
    iconMessageWebPagePublisher = findViewById(R.id.ch_iconMessageWebPagePublisher);
    textMessageWebPagePublisher = findViewById(R.id.ch_textMessageWebPagePublisher);

    thumbnailMessageWebPage = findViewById(R.id.ch_thumbnailMessageWebPage);
    thumbnailMessageWebPage.setOnClickListener(this);
    thumbnailMessageWebPage.setOnLongClickListener((v) -> {
      if (listener != null) {
        listener.onWebPageLongClick();
        return true;
      }
      return false;
    });

    layoutMessageWebPageMeta = findViewById(R.id.ch_layoutMessageWebPageMeta);
    layoutMessageWebPageMeta.setOnClickListener(this);
    layoutMessageWebPageMeta.setOnLongClickListener((v) -> {
      if (listener != null) {
        listener.onWebPageLongClick();
        return true;
      }
      return false;
    });
  }

  public void setOnWebPageActionListener(@Nullable OnWebPageContentActionListener listener) {
    this.listener = listener;
  }

  public void setGravity(int gravity) {
    if (rootMessageWebPage != null && thumbnailMessageWebPage != null) {
      ConstraintSet set = new ConstraintSet();
      set.clone(rootMessageWebPage);

      if (gravity == Gravity.START) {
        set.setHorizontalBias(R.id.ch_thumbnailMessageWebPage, 0);
      } else if (gravity == Gravity.END) {
        set.setHorizontalBias(R.id.ch_thumbnailMessageWebPage, 1);
      }

      set.applyTo(rootMessageWebPage);
    }
  }

  public void setWebPage(@Nullable String messageId, WebPage webPage) {
    this.webPage = webPage;

    // set thumbnail
    if (webPage.getPreviewUrl() != null && thumbnailMessageWebPage != null) {
      thumbnailMessageWebPage.setVisibility(View.VISIBLE);

      LayoutParams params = (LayoutParams) thumbnailMessageWebPage.getLayoutParams();

      if (webPage.getWidth() > 0 && webPage.getHeight() > 0) {
        params.dimensionRatio = String.format(Locale.ENGLISH, "H,%d:%d", webPage.getWidth(), webPage.getHeight());
      } else {
        params.dimensionRatio = "H,1000:524";
      }

      thumbnailMessageWebPage.setWebPage(messageId, webPage);
    }

    // set meta
    if (webPage.getTitle() != null || webPage.getDescription() != null) {
      if (layoutMessageWebPageMeta != null) {
        layoutMessageWebPageMeta.setVisibility(View.VISIBLE);
      }

      if (webPage.getTitle() != null && textMessageWebPageTitle != null) {
        textMessageWebPageTitle.setVisibility(View.VISIBLE);
        textMessageWebPageTitle.setText(webPage.getTitle());
      }

      if (webPage.getDescription() != null && textMessageWebPageDescription != null) {
        textMessageWebPageDescription.setVisibility(View.VISIBLE);
        textMessageWebPageDescription.setText(webPage.getDescription());
      }

      if (webPage.getPublisher() != null) {
        if (layoutMessageWebPagePublisher != null) {
          layoutMessageWebPagePublisher.setVisibility(View.VISIBLE);
        }

        if (iconMessageWebPagePublisher != null) {
          if (Const.PUBLISHER_YOUTUBE.equals(webPage.getPublisher())) {
            iconMessageWebPagePublisher.setVisibility(View.VISIBLE);
            iconMessageWebPagePublisher.setImageResource(R.drawable.ch_logo_youtube);
          }
        }

        if (webPage.getPublisher() != null && textMessageWebPagePublisher != null) {
          textMessageWebPagePublisher.setVisibility(View.VISIBLE);
          textMessageWebPagePublisher.setText(webPage.getPublisher());
        }
      }
    }
  }

  @Override
  public void clear() {
    if (thumbnailMessageWebPage != null) {
      thumbnailMessageWebPage.clear();
    }
  }

  @Override
  public void resetView() {
    if (this.webPage != null) {
      this.webPage = null;

      if (thumbnailMessageWebPage != null) {
        thumbnailMessageWebPage.setVisibility(View.GONE);
      }
      if (layoutMessageWebPageMeta != null) {
        layoutMessageWebPageMeta.setVisibility(View.GONE);
      }
      if (textMessageWebPageTitle != null) {
        textMessageWebPageTitle.setVisibility(View.GONE);
      }
      if (textMessageWebPageDescription != null) {
        textMessageWebPageDescription.setVisibility(View.GONE);
      }
      if (layoutMessageWebPagePublisher != null) {
        layoutMessageWebPagePublisher.setVisibility(View.GONE);
      }
      if (iconMessageWebPagePublisher != null) {
        iconMessageWebPagePublisher.setVisibility(View.GONE);
      }
      if (textMessageWebPagePublisher != null) {
        textMessageWebPagePublisher.setVisibility(View.GONE);
      }
    }
  }

  @Override
  public void onClick(View v) {
    if (webPage != null && listener != null) {
      listener.onWebPageClick(webPage.getUrl());
    }
  }
}
