package com.zoyi.channel.plugin.android.activity.chat.view.profilebot;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.View;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.store.ProfileBotStore;
import com.zoyi.channel.plugin.android.util.*;
import com.zoyi.channel.plugin.android.view.layout.ChBorderLayout;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;

public class ProfileBotInputNumberView extends BaseProfileBotInputView {

  public ProfileBotInputNumberView(@NonNull Context context) {
    super(context);
  }

  public ProfileBotInputNumberView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
  }

  public ProfileBotInputNumberView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
  }

  private ChBorderLayout borderLayout;
  private WatchedEditText editText;
  private View progressView;
  private View button;
  private AppCompatImageView imageSubmit;

  private FetchState fetchState = FetchState.COMPLETE;

  @Initializer
  @Override
  public void initView(View root) {
    borderLayout = root.findViewById(R.id.ch_rootProfileBotInputNumberView);
    editText = root.findViewById(R.id.ch_editProfileBotInputNumber);
    progressView = root.findViewById(R.id.ch_progressProfileBotInputNumber);
    button = root.findViewById(R.id.ch_buttonProfileBotInputNumber);
    imageSubmit = root.findViewById(R.id.ch_imageProfileBotInputNumberSubmit);

    editText.setOnFocusChangeListener((v, hasFocus) -> {
      resolveBorder(hasFocus);

      ProfileBotStore.get().requestFocus.set(true);
    });
    button.setOnClickListener(v -> submit());
  }

  @Nullable
  @Override
  public Object getValue() {
    if (editText != null) {
      Object number = ParseUtils.parseNumber(editText.getString());

      if (number != null) {
        return number;
      }
    }
    return null;
  }

  @Override
  public void restore(@Nullable Object value, FetchState fetchState) {
    this.fetchState = fetchState;

    Views.setVisibility(progressView, fetchState == FetchState.LOADING);
    Views.setVisibility(button, fetchState != FetchState.LOADING);

    editText.setEnabled(fetchState != FetchState.LOADING);

    imageSubmit.setColorFilter(ResUtils.getColor(fetchState == FetchState.FAILED ? R.color.ch_orange400 : R.color.ch_cobalt400));

    resolveBorder(editText.hasFocus());

    Object number = ParseUtils.parseNumber(value != null ? value.toString() : null);
    if (number != null) {
      editText.setText(number.toString());
      editText.setSelection(editText.getString().length());
    } else {
      editText.setText(null);
    }
  }

  private void resolveBorder(boolean hasFocus) {
    if (fetchState == FetchState.FAILED) {
      borderLayout.setBorderColor(ResUtils.getColor(R.color.ch_orange400));
    } else {
      borderLayout.setBorderColor(ResUtils.getColor(hasFocus ? R.color.ch_cobalt400 : R.color.ch_grey300));
    }
  }

  @Override
  public void focus() {
    editText.requestFocus();
  }

  @Override
  public int getLayoutId() {
    return R.layout.ch_view_profile_bot_input_number;
  }
}
