package com.zoyi.channel.plugin.android.activity.chat.view.navigation;

import android.content.Context;
import androidx.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.selector.ChatsSelector;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.button.ThemeEffectiveView;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;

public class HostHeaderView extends LinearLayout implements ThemeEffectiveView {

  private AvatarLayout avatar;
  private TextView textHost;

  @Nullable
  private Binder binder;

  public HostHeaderView(Context context) {
    super(context);
    init(context);
  }

  public HostHeaderView(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public HostHeaderView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  @Initializer
  private void init(Context context) {
    View view = LayoutInflater.from(context).inflate(R.layout.ch_plugin_navigation_host, this, true);

    avatar = view.findViewById(R.id.ch_avatarChatNavigationHost);
    textHost = view.findViewById(R.id.ch_textChatNavigationHostName);
  }

  public void attachUserChat(@Nullable String chatId) {
    if (binder == null) {
      binder = ChatsSelector.binderHost(chatId, profile -> {
        if (profile != null) {
          avatar.set(profile);
          textHost.setText(profile.getName());
        }
      });
    }
  }

  @Override
  protected void onDetachedFromWindow() {
    super.onDetachedFromWindow();

    if (binder != null) {
      binder.unbind();
      binder = null;
    }
  }

  @Override
  public void onThemeChange(int backColor, int textColor) {
    textHost.setTextColor(textColor);
  }
}
