package com.zoyi.channel.plugin.android.activity.chat.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.chat.type.ContentType;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.ActionButton;
import com.zoyi.channel.plugin.android.model.rest.Message;

public class SendActionItem extends SendItem {

  @Nullable
  private String actionType;

  @Nullable
  private ActionButton actionButton;

  @Nullable
  private String text;

  public SendActionItem(@Nullable String chatId, @NonNull String actionType, @Nullable ActionButton actionButton) {
    this(chatId, actionType, actionButton, null);
  }

  public SendActionItem(@Nullable String chatId, @NonNull String actionType, @Nullable ActionButton actionButton, @Nullable String text) {
    super(chatId);

    this.actionType = actionType;
    this.actionButton = actionButton;
    this.text = text;
  }

  @Override
  public ContentType getContentType() {
    return ContentType.ACTION;
  }

  @Override
  public MessageType getType() {
    return MessageType.SENDING_ACTION;
  }

  @Override
  public Long getPrimaryKey() {
    return createdAt * Const.SENDING_MESSAGE_PRIMARY_KEY_MULTIPLER;
  }

  @Nullable
  public String getActionType() {
    return actionType;
  }

  @Nullable
  public ActionButton getActionButton() {
    return actionButton;
  }

  @Nullable
  public String getText() {
    return text;
  }

  public void updateMessageOnActionInput(@NonNull Message message) {
    if (getContentType() == ContentType.ACTION && actionButton != null) {
      actionButton.setMessage(message);
    }
  }

  @Override
  public boolean shouldShowTempMessage() {
    return true;
  }
}
