package com.zoyi.channel.plugin.android.activity.chat.manager;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.zoyi.channel.plugin.android.activity.chat.listener.chatmanager.OnMessageSendStateChangeListener;
import com.zoyi.channel.plugin.android.activity.chat.model.SendItem;
import com.zoyi.rx.Observable;

import java.util.List;

public interface ChatManagerInterface {

  void attachListener(@Nullable OnMessageSendStateChangeListener listener);

  void clearListener();

  void sendMessage(SendItem item);

  void sendMessages(List<SendItem> items);

  void addFailedItems(List<SendItem> items);

  void resend(SendItem item);

  void remove(SendItem item);

  void cancelRecentSendingFile();

  int getWaitingFileCount();

  int getCurrentFileUploadProgress();

  @NonNull
  List<SendItem> getUnsentItems();

  Observable<Integer> getUploadProgressObservable();

  Observable<Integer> getWaitingCountObservable();

  void release();
}
